/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.SegmentReplicationPerGroupStats;
import org.opensearch.index.SegmentReplicationRejectionStats;
import org.opensearch.index.SegmentReplicationStats;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class SegmentReplicationStatsTracker {
    private final IndicesService indicesService;
    private final Map<ShardId, AtomicInteger> rejectionCount;

    public SegmentReplicationStatsTracker(IndicesService indicesService) {
        this.indicesService = indicesService;
        this.rejectionCount = ConcurrentCollections.newConcurrentMap();
    }

    public SegmentReplicationRejectionStats getTotalRejectionStats() {
        return new SegmentReplicationRejectionStats(this.rejectionCount.values().stream().mapToInt(AtomicInteger::get).sum());
    }

    protected Map<ShardId, AtomicInteger> getRejectionCount() {
        return this.rejectionCount;
    }

    public SegmentReplicationStats getStats() {
        HashMap<ShardId, SegmentReplicationPerGroupStats> stats = new HashMap<ShardId, SegmentReplicationPerGroupStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                if (!indexShard.indexSettings().isSegRepEnabledOrRemoteNode() || !indexShard.routingEntry().primary()) continue;
                stats.putIfAbsent(indexShard.shardId(), this.getStatsForShard(indexShard));
            }
        }
        return new SegmentReplicationStats(stats);
    }

    public void incrementRejectionCount(ShardId shardId) {
        this.rejectionCount.compute(shardId, (k, v) -> {
            if (v == null) {
                return new AtomicInteger(1);
            }
            v.incrementAndGet();
            return v;
        });
    }

    public SegmentReplicationPerGroupStats getStatsForShard(IndexShard indexShard) {
        return new SegmentReplicationPerGroupStats(indexShard.shardId(), indexShard.getReplicationStatsForTrackedReplicas(), Optional.ofNullable(this.rejectionCount.get(indexShard.shardId())).map(AtomicInteger::get).orElse(0).intValue());
    }
}

