/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.Scroll;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.SharingRecord;
import org.opensearch.security.spi.resources.sharing.CreatedBy;
import org.opensearch.security.spi.resources.sharing.Recipient;
import org.opensearch.security.spi.resources.sharing.Recipients;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ResourceSharingIndexHandler {
    private static final Logger LOGGER = LogManager.getLogger(ResourceSharingIndexHandler.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final ResourcePluginInfo resourcePluginInfo;
    public static final Map<String, Object> INDEX_SETTINGS = Map.of("index.number_of_shards", 1, "index.hidden", "true");

    @Inject
    public ResourceSharingIndexHandler(Client client, ThreadPool threadPool, ResourcePluginInfo resourcePluginInfo) {
        this.client = client;
        this.threadPool = threadPool;
        this.resourcePluginInfo = resourcePluginInfo;
    }

    public void createResourceSharingIndicesIfAbsent(Set<String> resourceIndices) {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            for (String resourceIndex : resourceIndices) {
                String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
                CreateIndexRequest cir = new CreateIndexRequest(resourceSharingIndex).settings(INDEX_SETTINGS).waitForActiveShards(1);
                ActionListener cirListener = ActionListener.wrap(response -> {
                    ctx.restore();
                    LOGGER.info("Resource sharing index {} created.", (Object)resourceSharingIndex);
                }, failResponse -> LOGGER.info("Index {} already exists.", (Object)resourceSharingIndex));
                this.client.admin().indices().create(cir, cirListener);
            }
        }
    }

    public static String getSharingIndex(String resourceIndex) {
        return resourceIndex + "-sharing";
    }

    public void updateResourceVisibility(String resourceId, String resourceIndex, List<String> principals, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            UpdateRequest ur = (UpdateRequest)((UpdateRequestBuilder)this.client.prepareUpdate(resourceIndex, resourceId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setDoc(Map.of("all_shared_principals", principals)).setId(resourceId).request();
            ActionListener urListener = ActionListener.wrap(response -> {
                ctx.restore();
                LOGGER.info("Successfully updated visibility of resource {} in index {} to principals {}.", (Object)resourceIndex, (Object)resourceId, (Object)principals);
                listener.onResponse(response);
            }, e -> {
                LOGGER.error("Failed to update visibility in [{}] for resource [{}]", (Object)resourceIndex, (Object)resourceId, e);
                listener.onFailure(e);
            });
            this.client.update(ur, urListener);
        }
    }

    public void fetchAndUpdateResourceVisibility(String resourceId, String resourceIndex, ActionListener<Void> listener) {
        StepListener sharingInfoListener = new StepListener();
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            if (sharingInfo == null) {
                LOGGER.debug("No sharing info found for resource {} in index {}", (Object)resourceId, (Object)resourceIndex);
                listener.onResponse(null);
                return;
            }
            this.updateResourceVisibility(resourceId, resourceIndex, sharingInfo.getAllPrincipals(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                LOGGER.debug("Successfully updated visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex);
                listener.onResponse(null);
            }, e -> {
                LOGGER.error("Failed to update principals field in {} for resource {}", (Object)resourceIndex, (Object)resourceId, e);
                listener.onResponse(null);
            }));
        }, failResponse -> {
            LOGGER.error(failResponse.getMessage());
            listener.onFailure(failResponse);
        });
    }

    public void indexResourceSharing(String resourceId, String resourceIndex, CreatedBy createdBy, ShareWith shareWith, ActionListener<ResourceSharing> listener) throws IOException {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            ResourceSharing entry = new ResourceSharing(resourceId, createdBy, shareWith);
            IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(entry.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.CREATE).setId(resourceId).request();
            ActionListener irListener = ActionListener.wrap(idxResponse -> {
                ctx.restore();
                LOGGER.info("Successfully created {} entry for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                this.updateResourceVisibility(resourceId, resourceIndex, List.of("user:" + createdBy.getUsername()), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                    LOGGER.debug("postUpdate: Successfully updated visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex);
                    listener.onResponse((Object)entry);
                }, e -> {
                    LOGGER.error("Failed to create principals field in [{}] for resource [{}]", (Object)resourceIndex, (Object)resourceId, e);
                    listener.onResponse((Object)entry);
                }));
            }, e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    LOGGER.debug("Entry for [{}] already exists in [{}], skipping", (Object)resourceId, (Object)resourceSharingIndex);
                    listener.onResponse((Object)entry);
                } else {
                    LOGGER.error("Failed to create entry in [{}] for resource [{}]", (Object)resourceSharingIndex, (Object)resourceId, e);
                    listener.onFailure(e);
                }
            });
            this.client.index(ir, irListener);
        }
    }

    public void fetchAllResourceIds(String resourceIndex, ActionListener<Set<String>> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Fetching all documents asynchronously from {}", (Object)resourceSharingIndex);
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{resourceSharingIndex});
            searchRequest.scroll(scroll);
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            this.executeSearchRequest(scroll, searchRequest, (AbstractQueryBuilder<? extends AbstractQueryBuilder<?>>)query, (ActionListener<Set<String>>)ActionListener.wrap(resourceIds -> {
                ctx.restore();
                LOGGER.debug("Found {} documents in {}", (Object)resourceIds.size(), (Object)resourceSharingIndex);
                listener.onResponse(resourceIds);
            }, exception -> {
                LOGGER.error("Search failed while locating all records inside resourceIndex={} ", (Object)resourceIndex, exception);
                listener.onFailure(exception);
            }));
        }
    }

    public void fetchAllResourceSharingRecords(String resourceIndex, ActionListener<Set<SharingRecord>> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Fetching all resource-sharing records asynchronously from {}", (Object)resourceSharingIndex);
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{resourceSharingIndex});
            searchRequest.scroll(scroll);
            MatchAllQueryBuilder query = QueryBuilders.matchAllQuery();
            this.executeAllSearchRequest(resourceIndex, scroll, searchRequest, (AbstractQueryBuilder<? extends AbstractQueryBuilder<?>>)query, (ActionListener<Set<SharingRecord>>)ActionListener.wrap(recs -> {
                ctx.restore();
                LOGGER.debug("Found {} resource-sharing records in {}", (Object)recs.size(), (Object)resourceSharingIndex);
                listener.onResponse(recs);
            }, exception -> {
                LOGGER.error("Search failed while locating all records inside resourceIndex={} ", (Object)resourceIndex, exception);
                listener.onFailure(exception);
            }));
        }
    }

    public void fetchAccessibleResourceIds(String resourceIndex, Set<String> entities, ActionListener<Set<String>> listener) {
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            SearchRequest searchRequest = new SearchRequest(new String[]{resourceIndex});
            searchRequest.scroll(scroll);
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"all_shared_principals", entities));
            this.executeIdCollectingSearchRequest(scroll, searchRequest, (AbstractQueryBuilder<? extends AbstractQueryBuilder<?>>)boolQuery, (ActionListener<Set<String>>)ActionListener.wrap(resourceIds -> {
                ctx.restore();
                LOGGER.debug("Found {} accessible resources in {} for entities {}", (Object)resourceIds.size(), (Object)resourceIndex, (Object)entities);
                listener.onResponse(resourceIds);
            }, exception -> {
                if (exception instanceof IndexNotFoundException) {
                    LOGGER.debug("Index {} not found, returning empty set", (Object)resourceIndex, exception);
                    listener.onResponse(Collections.emptySet());
                    return;
                }
                LOGGER.error("Search failed for resourceIndex={}, entities={}", (Object)resourceIndex, (Object)entities, exception);
                listener.onFailure(exception);
            }));
        }
    }

    private void executeIdCollectingSearchRequest(Scroll scroll, SearchRequest searchRequest, AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> query, ActionListener<Set<String>> listener) {
        SearchSourceBuilder ssb = new SearchSourceBuilder().query(query).size(1000).fetchSource(false);
        searchRequest.source(ssb);
        StepListener searchStep = new StepListener();
        this.client.search(searchRequest, (ActionListener)searchStep);
        searchStep.whenComplete(initialResponse -> {
            HashSet<String> collectedResourceIds = new HashSet<String>();
            String scrollId = initialResponse.getScrollId();
            this.processScrollIds(collectedResourceIds, scroll, scrollId, initialResponse.getHits().getHits(), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void processScrollIds(Set<String> collectedResourceIds, Scroll scroll, String scrollId, SearchHit[] hits, ActionListener<Set<String>> listener) {
        block4: {
            block3: {
                if (hits == null) break block3;
                if (hits.length != 0) break block4;
            }
            this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onResponse((Object)collectedResourceIds), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        for (SearchHit hit : hits) {
            collectedResourceIds.add(hit.getId());
        }
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(scroll);
        this.client.searchScroll(scrollRequest, ActionListener.wrap(scrollResponse -> this.processScrollIds(collectedResourceIds, scroll, scrollResponse.getScrollId(), scrollResponse.getHits().getHits(), listener), e -> this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onFailure(e), ex -> {
            e.addSuppressed((Throwable)ex);
            listener.onFailure(e);
        }))));
    }

    public void fetchSharingInfo(String resourceIndex, String resourceId, ActionListener<ResourceSharing> listener) {
        if (StringUtils.isBlank((CharSequence)resourceIndex) || StringUtils.isBlank((CharSequence)resourceId)) {
            listener.onFailure((Exception)new IllegalArgumentException("resourceIndex and resourceId must not be null or empty"));
            return;
        }
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Fetching document from {}, matching resource_id: {}", (Object)resourceSharingIndex, (Object)resourceId);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            GetRequest getRequest = new GetRequest(resourceSharingIndex).id(resourceId);
            this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                ctx.restore();
                try {
                    if (!getResponse.isExists()) {
                        LOGGER.debug("No document found in {} matching resource_id: {} and source_idx {}", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse(null);
                        return;
                    }
                    try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                        parser.nextToken();
                        ResourceSharing resourceSharing = ResourceSharing.fromXContent((XContentParser)parser);
                        resourceSharing.setResourceId(getResponse.getId());
                        LOGGER.debug("Successfully fetched document from {} matching resource_id: {} and source_idx: {}", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse((Object)resourceSharing);
                    }
                }
                catch (Exception e) {
                    String failureResponse = "Failed to parse document matching resource_id: " + resourceId + " and source_idx: " + resourceIndex + " from " + resourceSharingIndex;
                    LOGGER.error(failureResponse, (Throwable)e);
                    listener.onFailure((Exception)new OpenSearchStatusException(failureResponse, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }
            }, exception -> {
                String failureResponse = "Something went wrong while fetching resource sharing record for resource_id: " + resourceId + " and source_idx: " + resourceIndex + " from " + resourceSharingIndex;
                LOGGER.error(failureResponse, (Throwable)exception);
                listener.onFailure((Exception)new OpenSearchStatusException(failureResponse, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        }
    }

    public void share(String resourceId, String resourceIndex, ShareWith shareWith, ActionListener<ResourceSharing> listener) {
        StepListener sharingInfoListener = new StepListener();
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            if (sharingInfo == null) {
                LOGGER.debug("No sharing record found for resource {}", (Object)resourceId);
                listener.onResponse(null);
                return;
            }
            for (String accessLevel : shareWith.accessLevels()) {
                Recipients target = shareWith.atAccessLevel(accessLevel);
                sharingInfo.share(accessLevel, target);
            }
            String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(sharingInfo.getResourceId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(sharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                ActionListener irListener = ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully updated {} entry for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                    this.updateResourceVisibility(resourceId, resourceIndex, sharingInfo.getAllPrincipals(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        LOGGER.debug("Successfully updated visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse(sharingInfo);
                    }, e -> {
                        LOGGER.error("Failed to update principals field in [{}] for resource [{}]", (Object)resourceIndex, (Object)resourceId, e);
                        listener.onResponse(sharingInfo);
                    }));
                }, failResponse -> {
                    LOGGER.error(failResponse.getMessage());
                    listener.onFailure(failResponse);
                });
                this.client.index(ir, irListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void revoke(String resourceId, String resourceIndex, ShareWith revokeAccess, ActionListener<ResourceSharing> listener) {
        if (StringUtils.isBlank((CharSequence)resourceId) || StringUtils.isBlank((CharSequence)resourceIndex) || revokeAccess == null) {
            listener.onFailure((Exception)new IllegalArgumentException("resourceId, resourceIndex, and revokeAccess must not be null or empty"));
            return;
        }
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        StepListener sharingInfoListener = new StepListener();
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            assert (sharingInfo != null);
            for (String accessLevel : revokeAccess.accessLevels()) {
                Recipients target = revokeAccess.atAccessLevel(accessLevel);
                LOGGER.debug("Revoking access for resource {} in {} for entities: {} and accessLevel: {}", (Object)resourceId, (Object)resourceIndex, (Object)target, (Object)accessLevel);
                sharingInfo.revoke(accessLevel, target);
            }
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(sharingInfo.getResourceId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(sharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                ActionListener irListener = ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully revoked access of {} to resource {} in index {}.", (Object)revokeAccess, (Object)resourceId, (Object)resourceIndex);
                    this.updateResourceVisibility(resourceId, resourceIndex, sharingInfo.getAllPrincipals(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        LOGGER.debug("Successfully updated visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse(sharingInfo);
                    }, e -> {
                        LOGGER.error("Failed to update principals field in [{}] for resource [{}]", (Object)resourceIndex, (Object)resourceId, e);
                        listener.onResponse(sharingInfo);
                    }));
                }, failResponse -> {
                    LOGGER.error(failResponse.getMessage());
                    listener.onFailure(failResponse);
                });
                this.client.index(ir, irListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void patchSharingInfo(String resourceId, String resourceIndex, ShareWith add, ShareWith revoke, ActionListener<ResourceSharing> listener) {
        StepListener sharingInfoListener = new StepListener();
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        this.fetchSharingInfo(resourceIndex, resourceId, (ActionListener<ResourceSharing>)sharingInfoListener);
        sharingInfoListener.whenComplete(sharingInfo -> {
            ShareWith pruned;
            ShareWith updatedShareWith = sharingInfo.getShareWith();
            if (updatedShareWith == null) {
                updatedShareWith = new ShareWith(new HashMap());
            }
            if (add != null) {
                updatedShareWith = updatedShareWith.add(add);
            }
            if (revoke != null) {
                updatedShareWith = updatedShareWith.revoke(revoke);
            }
            ShareWith cleaned = null;
            if (updatedShareWith != null && !(pruned = updatedShareWith.prune()).isPrivate()) {
                cleaned = pruned;
            }
            ResourceSharing updatedSharingInfo = new ResourceSharing(resourceId, sharingInfo.getCreatedBy(), cleaned);
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                IndexRequest ir = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(resourceSharingIndex).setId(resourceId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(updatedSharingInfo.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setOpType(DocWriteRequest.OpType.INDEX).request();
                this.client.index(ir, ActionListener.wrap(idxResponse -> {
                    ctx.restore();
                    LOGGER.info("Successfully updated {} resource sharing info for resource {} in index {}.", (Object)resourceSharingIndex, (Object)resourceId, (Object)resourceIndex);
                    this.updateResourceVisibility(resourceId, resourceIndex, updatedSharingInfo.getAllPrincipals(), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> {
                        LOGGER.debug("Successfully updated visibility for resource {} within index {}", (Object)resourceId, (Object)resourceIndex);
                        listener.onResponse((Object)updatedSharingInfo);
                    }, e -> {
                        LOGGER.error("Failed to update principals field in [{}] for resource [{}]", (Object)resourceIndex, (Object)resourceId, e);
                        listener.onResponse((Object)updatedSharingInfo);
                    }));
                }, e -> {
                    LOGGER.error(e.getMessage());
                    listener.onFailure(e);
                }));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void deleteResourceSharingRecord(String resourceId, String resourceIndex, ActionListener<Boolean> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        LOGGER.debug("Deleting documents asynchronously from {} where source_idx = {} and resource_id = {}", (Object)resourceSharingIndex, (Object)resourceIndex, (Object)resourceId);
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            DeleteRequest deleteRequest = new DeleteRequest(resourceSharingIndex, resourceId);
            this.client.delete(deleteRequest, ActionListener.wrap(deleteResponse -> {
                ctx.restore();
                boolean deleted = DocWriteResponse.Result.DELETED.equals((Object)deleteResponse.getResult());
                if (deleted) {
                    LOGGER.debug("Successfully deleted {} documents from {}", (Object)deleted, (Object)resourceSharingIndex);
                    listener.onResponse((Object)true);
                } else {
                    LOGGER.debug("No documents found to delete in {} for source_idx: {} and resource_id: {}", (Object)resourceSharingIndex, (Object)resourceIndex, (Object)resourceId);
                    listener.onResponse((Object)false);
                }
            }, failResponse -> {
                LOGGER.error("Failed to delete documents from {}", (Object)resourceSharingIndex, failResponse);
                listener.onFailure(failResponse);
            }));
        }
    }

    private void executeSearchRequest(Scroll scroll, SearchRequest searchRequest, AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> query, ActionListener<Set<String>> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).size(1000).fetchSource(new String[]{"resource_id"}, null);
        searchRequest.source(searchSourceBuilder);
        StepListener searchStep = new StepListener();
        this.client.search(searchRequest, (ActionListener)searchStep);
        searchStep.whenComplete(initialResponse -> {
            HashSet<String> collectedResourceIds = new HashSet<String>();
            String scrollId = initialResponse.getScrollId();
            this.processScrollResultsAndCollectResourceIds(collectedResourceIds, scroll, scrollId, initialResponse.getHits().getHits(), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void executeAllSearchRequest(String resourceIndex, Scroll scroll, SearchRequest searchRequest, AbstractQueryBuilder<? extends AbstractQueryBuilder<?>> query, ActionListener<Set<SharingRecord>> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(query).size(1000).fetchSource(new String[]{"resource_id", "created_by", "share_with"}, null);
        searchRequest.source(searchSourceBuilder);
        StepListener searchStep = new StepListener();
        this.client.search(searchRequest, (ActionListener)searchStep);
        searchStep.whenComplete(initialResponse -> {
            HashSet<SharingRecord> recs = new HashSet<SharingRecord>();
            String scrollId = initialResponse.getScrollId();
            this.processScrollResultsAndCollectSharingRecords(null, true, resourceIndex, recs, scroll, scrollId, initialResponse.getHits().getHits(), listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void fetchAccessibleResourceSharingRecords(String resourceIndex, User user, Set<String> flatPrincipals, ActionListener<Set<SharingRecord>> listener) {
        String resourceSharingIndex = ResourceSharingIndexHandler.getSharingIndex(resourceIndex);
        ThreadContext.StoredContext stored = this.threadPool.getThreadContext().stashContext();
        this.fetchAccessibleResourceIds(resourceIndex, flatPrincipals, (ActionListener<Set<String>>)ActionListener.wrap(ids -> {
            if (ids == null || ids.isEmpty()) {
                stored.restore();
                listener.onResponse(Collections.emptySet());
                return;
            }
            ArrayList idList = new ArrayList(ids);
            int BATCH = 1000;
            ConcurrentHashMap.KeySetView out = ConcurrentHashMap.newKeySet();
            AtomicInteger cursor = new AtomicInteger(0);
            String[] includes = new String[]{"resource_id", "created_by", "share_with"};
            AtomicReference<Runnable> submitNextRef = new AtomicReference<Runnable>();
            submitNextRef.set(() -> {
                int start = cursor.getAndAdd(1000);
                if (start >= idList.size()) {
                    stored.restore();
                    listener.onResponse((Object)out);
                    return;
                }
                int end = Math.min(start + 1000, idList.size());
                MultiGetRequest mget = new MultiGetRequest();
                FetchSourceContext fsc = new FetchSourceContext(true, includes, Strings.EMPTY_ARRAY);
                for (int i = start; i < end; ++i) {
                    mget.add(new MultiGetRequest.Item(resourceSharingIndex, (String)idList.get(i)).fetchSourceContext(fsc));
                }
                this.client.multiGet(mget, ActionListener.wrap(mres -> {
                    for (MultiGetItemResponse item : mres.getResponses()) {
                        GetResponse gr;
                        if (item == null || item.isFailed() || (gr = item.getResponse()) == null || !gr.isExists()) continue;
                        try (XContentParser p = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)gr.getSourceAsBytesRef(), (MediaType)XContentType.JSON);){
                            p.nextToken();
                            ResourceSharing rs = ResourceSharing.fromXContent((XContentParser)p);
                            boolean canShare = this.canUserShare(user, false, rs, resourceIndex);
                            out.add(new SharingRecord(rs, canShare));
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Failed to parse resource-sharing doc id={}", (Object)gr.getId(), (Object)ex);
                        }
                    }
                    ((Runnable)submitNextRef.get()).run();
                }, e -> {
                    try {
                        listener.onFailure(e);
                    }
                    finally {
                        stored.restore();
                    }
                }));
            });
            ((Runnable)submitNextRef.get()).run();
        }, e -> {
            stored.restore();
            listener.onFailure(e);
        }));
    }

    private void processScrollResultsAndCollectResourceIds(Set<String> collectedResourceIds, Scroll scroll, String scrollId, SearchHit[] hits, ActionListener<Set<String>> listener) {
        block4: {
            block3: {
                if (hits == null) break block3;
                if (hits.length != 0) break block4;
            }
            this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onResponse((Object)collectedResourceIds), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            if (source == null || !source.containsKey("resource_id")) continue;
            collectedResourceIds.add(source.get("resource_id").toString());
        }
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(scroll);
        this.client.searchScroll(scrollRequest, ActionListener.wrap(scrollResponse -> this.processScrollResultsAndCollectResourceIds(collectedResourceIds, scroll, scrollResponse.getScrollId(), scrollResponse.getHits().getHits(), listener), e -> this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onFailure(e), ex -> {
            e.addSuppressed((Throwable)ex);
            listener.onFailure(e);
        }))));
    }

    private void processScrollResultsAndCollectSharingRecords(User user, boolean isAdmin, String resourceIndex, Set<SharingRecord> resourceSharingRecords, Scroll scroll, String scrollId, SearchHit[] hits, ActionListener<Set<SharingRecord>> listener) {
        block13: {
            block12: {
                if (hits == null) break block12;
                if (hits.length != 0) break block13;
            }
            this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onResponse((Object)resourceSharingRecords), arg_0 -> listener.onFailure(arg_0)));
            return;
        }
        for (SearchHit hit : hits) {
            try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)hit.getSourceRef(), (MediaType)XContentType.JSON);){
                parser.nextToken();
                ResourceSharing rs = ResourceSharing.fromXContent((XContentParser)parser);
                boolean canShare = this.canUserShare(user, isAdmin, rs, resourceIndex);
                resourceSharingRecords.add(new SharingRecord(rs, canShare));
            }
            catch (Exception e2) {
                LOGGER.warn("Failed to parse resource-sharing doc id={}", (Object)hit.getId(), (Object)e2);
            }
        }
        SearchScrollRequest scrollReq = new SearchScrollRequest(scrollId).scroll(scroll);
        this.client.searchScroll(scrollReq, ActionListener.wrap(sr -> this.processScrollResultsAndCollectSharingRecords(user, isAdmin, resourceIndex, resourceSharingRecords, scroll, sr.getScrollId(), sr.getHits().getHits(), listener), e -> this.clearScroll(scrollId, (ActionListener<Void>)ActionListener.wrap(ignored -> listener.onFailure(e), ex -> {
            e.addSuppressed((Throwable)ex);
            listener.onFailure(e);
        }))));
    }

    private void clearScroll(String scrollId, ActionListener<Void> listener) {
        if (scrollId == null) {
            listener.onResponse(null);
            return;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        this.client.clearScroll(clearScrollRequest, ActionListener.wrap(r -> listener.onResponse(null), e -> {
            LOGGER.warn("Failed to clear scroll context", (Throwable)e);
            listener.onResponse(null);
        }));
    }

    public boolean groupAllows(String resourceIndex, String accessLevel, String requiredAction) {
        String resourceType = this.resourcePluginInfo.typeByIndex(resourceIndex);
        if (resourceType == null || accessLevel == null || requiredAction == null) {
            return false;
        }
        return this.resourcePluginInfo.flattenedForType(resourceType).resolve(Set.of(accessLevel)).contains((Object)requiredAction);
    }

    public boolean canUserShare(User user, boolean isAdmin, ResourceSharing resourceSharingRecord, String resourceType) {
        if (resourceSharingRecord == null) {
            return false;
        }
        if (isAdmin || resourceSharingRecord.isCreatedBy(user.getName())) {
            return true;
        }
        if (resourceSharingRecord.isSharedWithEveryone()) {
            return true;
        }
        ShareWith sw = resourceSharingRecord.getShareWith();
        if (sw == null || sw.getSharingInfo().isEmpty()) {
            return false;
        }
        Set<String> users = Set.of(user.getName());
        HashSet<String> roles = new HashSet<String>((Collection<String>)user.getSecurityRoles());
        HashSet<String> backend = new HashSet<String>((Collection<String>)user.getRoles());
        for (String level : sw.getSharingInfo().keySet()) {
            if (!this.groupAllows(resourceType, level, "cluster:admin/security/resource/share")) continue;
            if (resourceSharingRecord.isSharedWithEntity(Recipient.USERS, users, level)) {
                return true;
            }
            if (resourceSharingRecord.isSharedWithEntity(Recipient.ROLES, roles, level)) {
                return true;
            }
            if (!resourceSharingRecord.isSharedWithEntity(Recipient.BACKEND_ROLES, backend, level)) continue;
            return true;
        }
        return false;
    }
}

