from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

ESTONIAN_LANG_MODEL = {
    29: {  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.LIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.LIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    42: {  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    44: {  # 'C'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    41: {  # 'D'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    28: {  # 'E'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.POSITIVE,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.LIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.LIKELY,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    47: {  # 'F'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    48: {  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    39: {  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    36: {  # 'I'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    40: {  # 'J'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    24: {  # 'K'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    32: {  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    27: {  # 'M'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    34: {  # 'N'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    38: {  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.LIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.LIKELY,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    30: {  # 'P'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    61: {  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    35: {  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    23: {  # 'S'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        42: SequenceLikelihood.LIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.POSITIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.POSITIVE,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    26: {  # 'T'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.LIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.LIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.LIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    45: {  # 'U'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.LIKELY,  # 'K'
        32: SequenceLikelihood.LIKELY,  # 'L'
        27: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        26: SequenceLikelihood.LIKELY,  # 'T'
        45: SequenceLikelihood.LIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    33: {  # 'V'
        29: SequenceLikelihood.LIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    51: {  # 'W'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    57: {  # 'X'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    58: {  # 'Y'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    59: {  # 'Z'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    1: {  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.LIKELY,  # 'x'
        43: SequenceLikelihood.POSITIVE,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.LIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.LIKELY,  # 'ž'
    },
    21: {  # 'b'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    37: {  # 'c'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    11: {  # 'd'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.LIKELY,  # 'ž'
    },
    2: {  # 'e'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.POSITIVE,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.LIKELY,  # 'ž'
    },
    31: {  # 'f'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.LIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    15: {  # 'g'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    18: {  # 'h'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    3: {  # 'i'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.LIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.LIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    17: {  # 'j'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    9: {  # 'k'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    6: {  # 'l'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.POSITIVE,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    12: {  # 'm'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    8: {  # 'n'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    10: {  # 'o'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.POSITIVE,  # 'w'
        50: SequenceLikelihood.LIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    16: {  # 'p'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    60: {  # 'q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    13: {  # 'r'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.POSITIVE,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    4: {  # 's'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    5: {  # 't'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.LIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.LIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.LIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    7: {  # 'u'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.LIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.LIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.LIKELY,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    14: {  # 'v'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.LIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    46: {  # 'w'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.POSITIVE,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    50: {  # 'x'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    43: {  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.LIKELY,  # 'r'
        4: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    52: {  # 'z'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.LIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    56: {  # 'Ä'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    53: {  # 'Õ'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.LIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.NEGATIVE,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    62: {  # 'Ö'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.UNLIKELY,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.LIKELY,  # 'ö'
        22: SequenceLikelihood.NEGATIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    49: {  # 'Ü'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.NEGATIVE,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    19: {  # 'ä'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.NEGATIVE,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        33: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.POSITIVE,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    20: {  # 'õ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        42: SequenceLikelihood.NEGATIVE,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.POSITIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.POSITIVE,  # 'j'
        9: SequenceLikelihood.LIKELY,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.POSITIVE,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    25: {  # 'ö'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.LIKELY,  # 'm'
        8: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.POSITIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    22: {  # 'ü'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.UNLIKELY,  # 'G'
        39: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        21: SequenceLikelihood.LIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        18: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.LIKELY,  # 'j'
        9: SequenceLikelihood.POSITIVE,  # 'k'
        6: SequenceLikelihood.POSITIVE,  # 'l'
        12: SequenceLikelihood.POSITIVE,  # 'm'
        8: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        13: SequenceLikelihood.POSITIVE,  # 'r'
        4: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.UNLIKELY,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.UNLIKELY,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.POSITIVE,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
    63: {  # 'Š'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.NEGATIVE,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.NEGATIVE,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.NEGATIVE,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.UNLIKELY,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        38: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.NEGATIVE,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.UNLIKELY,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.UNLIKELY,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    54: {  # 'š'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        42: SequenceLikelihood.NEGATIVE,  # 'B'
        44: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.NEGATIVE,  # 'J'
        24: SequenceLikelihood.UNLIKELY,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        27: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.UNLIKELY,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        33: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.UNLIKELY,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.UNLIKELY,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.UNLIKELY,  # 'š'
        64: SequenceLikelihood.NEGATIVE,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    64: {  # 'Ž'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.UNLIKELY,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.NEGATIVE,  # 'J'
        24: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        27: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.NEGATIVE,  # 'S'
        26: SequenceLikelihood.NEGATIVE,  # 'T'
        45: SequenceLikelihood.UNLIKELY,  # 'U'
        33: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        21: SequenceLikelihood.NEGATIVE,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        17: SequenceLikelihood.NEGATIVE,  # 'j'
        9: SequenceLikelihood.NEGATIVE,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.NEGATIVE,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ö'
        49: SequenceLikelihood.UNLIKELY,  # 'Ü'
        19: SequenceLikelihood.NEGATIVE,  # 'ä'
        20: SequenceLikelihood.NEGATIVE,  # 'õ'
        25: SequenceLikelihood.NEGATIVE,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.NEGATIVE,  # 'ž'
    },
    55: {  # 'ž'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        42: SequenceLikelihood.NEGATIVE,  # 'B'
        44: SequenceLikelihood.NEGATIVE,  # 'C'
        41: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        47: SequenceLikelihood.UNLIKELY,  # 'F'
        48: SequenceLikelihood.NEGATIVE,  # 'G'
        39: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        40: SequenceLikelihood.UNLIKELY,  # 'J'
        24: SequenceLikelihood.NEGATIVE,  # 'K'
        32: SequenceLikelihood.NEGATIVE,  # 'L'
        27: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        38: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        26: SequenceLikelihood.NEGATIVE,  # 'T'
        45: SequenceLikelihood.NEGATIVE,  # 'U'
        33: SequenceLikelihood.NEGATIVE,  # 'V'
        51: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        59: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        21: SequenceLikelihood.UNLIKELY,  # 'b'
        37: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        18: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        17: SequenceLikelihood.UNLIKELY,  # 'j'
        9: SequenceLikelihood.UNLIKELY,  # 'k'
        6: SequenceLikelihood.UNLIKELY,  # 'l'
        12: SequenceLikelihood.UNLIKELY,  # 'm'
        8: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        13: SequenceLikelihood.UNLIKELY,  # 'r'
        4: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        46: SequenceLikelihood.NEGATIVE,  # 'w'
        50: SequenceLikelihood.NEGATIVE,  # 'x'
        43: SequenceLikelihood.UNLIKELY,  # 'y'
        52: SequenceLikelihood.NEGATIVE,  # 'z'
        56: SequenceLikelihood.NEGATIVE,  # 'Ä'
        53: SequenceLikelihood.NEGATIVE,  # 'Õ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ö'
        49: SequenceLikelihood.NEGATIVE,  # 'Ü'
        19: SequenceLikelihood.UNLIKELY,  # 'ä'
        20: SequenceLikelihood.UNLIKELY,  # 'õ'
        25: SequenceLikelihood.UNLIKELY,  # 'ö'
        22: SequenceLikelihood.UNLIKELY,  # 'ü'
        63: SequenceLikelihood.NEGATIVE,  # 'Š'
        54: SequenceLikelihood.NEGATIVE,  # 'š'
        64: SequenceLikelihood.UNLIKELY,  # 'Ž'
        55: SequenceLikelihood.UNLIKELY,  # 'ž'
    },
}

# Character Mapping Table(s):
CP775_ESTONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 42,  # 'B'
    67: 44,  # 'C'
    68: 41,  # 'D'
    69: 28,  # 'E'
    70: 47,  # 'F'
    71: 48,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 40,  # 'J'
    75: 24,  # 'K'
    76: 32,  # 'L'
    77: 27,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 30,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 23,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 33,  # 'V'
    87: 51,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 59,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 37,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 15,  # 'g'
    104: 18,  # 'h'
    105: 3,  # 'i'
    106: 17,  # 'j'
    107: 9,  # 'k'
    108: 6,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 16,  # 'p'
    113: 60,  # 'q'
    114: 13,  # 'r'
    115: 4,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 50,  # 'x'
    121: 43,  # 'y'
    122: 52,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ć'
    129: 22,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'ā'
    132: 19,  # 'ä'
    133: 0,  # 'ģ'
    134: 0,  # 'å'
    135: 0,  # 'ć'
    136: 0,  # 'ł'
    137: 0,  # 'ē'
    138: 0,  # 'Ŗ'
    139: 0,  # 'ŗ'
    140: 0,  # 'ī'
    141: 0,  # 'Ź'
    142: 56,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ō'
    148: 25,  # 'ö'
    149: 0,  # 'Ģ'
    150: CharacterCategory.SYMBOL,  # '¢'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 62,  # 'Ö'
    154: 49,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'Ā'
    161: 0,  # 'Ī'
    162: 0,  # 'ó'
    163: 0,  # 'Ż'
    164: 0,  # 'ż'
    165: 0,  # 'ź'
    166: CharacterCategory.SYMBOL,  # '”'
    167: CharacterCategory.SYMBOL,  # '¦'
    168: CharacterCategory.SYMBOL,  # '©'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: 0,  # 'Ł'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Ą'
    182: 0,  # 'Č'
    183: 0,  # 'Ę'
    184: 0,  # 'Ė'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Į'
    190: 63,  # 'Š'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ų'
    199: 0,  # 'Ū'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: 64,  # 'Ž'
    208: 0,  # 'ą'
    209: 0,  # 'č'
    210: 0,  # 'ę'
    211: 0,  # 'ė'
    212: 0,  # 'į'
    213: 54,  # 'š'
    214: 0,  # 'ų'
    215: 0,  # 'ū'
    216: 55,  # 'ž'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ō'
    227: 0,  # 'Ń'
    228: 20,  # 'õ'
    229: 53,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'ń'
    232: 0,  # 'Ķ'
    233: 0,  # 'ķ'
    234: 0,  # 'Ļ'
    235: 0,  # 'ļ'
    236: 0,  # 'ņ'
    237: 0,  # 'Ē'
    238: 0,  # 'Ņ'
    239: CharacterCategory.SYMBOL,  # '’'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '“'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '„'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP775_ESTONIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP775",
    language="Estonian",
    char_to_order_map=CP775_ESTONIAN_CHAR_TO_ORDER,
    language_model=ESTONIAN_LANG_MODEL,
    typical_positive_ratio=0.9843565818346288,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÄÕÖÜäõöüŠšŽž",
)

ISO_8859_4_ESTONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 42,  # 'B'
    67: 44,  # 'C'
    68: 41,  # 'D'
    69: 28,  # 'E'
    70: 47,  # 'F'
    71: 48,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 40,  # 'J'
    75: 24,  # 'K'
    76: 32,  # 'L'
    77: 27,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 30,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 23,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 33,  # 'V'
    87: 51,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 59,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 37,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 15,  # 'g'
    104: 18,  # 'h'
    105: 3,  # 'i'
    106: 17,  # 'j'
    107: 9,  # 'k'
    108: 6,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 16,  # 'p'
    113: 60,  # 'q'
    114: 13,  # 'r'
    115: 4,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 50,  # 'x'
    121: 43,  # 'y'
    122: 52,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ĸ'
    163: 0,  # 'Ŗ'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ĩ'
    166: 0,  # 'Ļ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 63,  # 'Š'
    170: 0,  # 'Ē'
    171: 0,  # 'Ģ'
    172: 0,  # 'Ŧ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 64,  # 'Ž'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ŗ'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ĩ'
    182: 0,  # 'ļ'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 54,  # 'š'
    186: 0,  # 'ē'
    187: 0,  # 'ģ'
    188: 0,  # 'ŧ'
    189: 0,  # 'Ŋ'
    190: 55,  # 'ž'
    191: 0,  # 'ŋ'
    192: 0,  # 'Ā'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 56,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Į'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ė'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ī'
    208: 0,  # 'Đ'
    209: 0,  # 'Ņ'
    210: 0,  # 'Ō'
    211: 0,  # 'Ķ'
    212: 0,  # 'Ô'
    213: 53,  # 'Õ'
    214: 62,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 0,  # 'Ų'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 49,  # 'Ü'
    221: 0,  # 'Ũ'
    222: 0,  # 'Ū'
    223: 0,  # 'ß'
    224: 0,  # 'ā'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 19,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'į'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ė'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ī'
    240: 0,  # 'đ'
    241: 0,  # 'ņ'
    242: 0,  # 'ō'
    243: 0,  # 'ķ'
    244: 0,  # 'ô'
    245: 20,  # 'õ'
    246: 25,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 0,  # 'ų'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 22,  # 'ü'
    253: 0,  # 'ũ'
    254: 0,  # 'ū'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_4_ESTONIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-4",
    language="Estonian",
    char_to_order_map=ISO_8859_4_ESTONIAN_CHAR_TO_ORDER,
    language_model=ESTONIAN_LANG_MODEL,
    typical_positive_ratio=0.9843565818346288,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÄÕÖÜäõöüŠšŽž",
)

ISO_8859_13_ESTONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 42,  # 'B'
    67: 44,  # 'C'
    68: 41,  # 'D'
    69: 28,  # 'E'
    70: 47,  # 'F'
    71: 48,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 40,  # 'J'
    75: 24,  # 'K'
    76: 32,  # 'L'
    77: 27,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 30,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 23,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 33,  # 'V'
    87: 51,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 59,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 37,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 15,  # 'g'
    104: 18,  # 'h'
    105: 3,  # 'i'
    106: 17,  # 'j'
    107: 9,  # 'k'
    108: 6,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 16,  # 'p'
    113: 60,  # 'q'
    114: 13,  # 'r'
    115: 4,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 50,  # 'x'
    121: 43,  # 'y'
    122: 52,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '”'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '„'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '“'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 0,  # 'Ą'
    193: 0,  # 'Į'
    194: 0,  # 'Ā'
    195: 0,  # 'Ć'
    196: 56,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Ę'
    199: 0,  # 'Ē'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 0,  # 'Ė'
    204: 0,  # 'Ģ'
    205: 0,  # 'Ķ'
    206: 0,  # 'Ī'
    207: 0,  # 'Ļ'
    208: 63,  # 'Š'
    209: 0,  # 'Ń'
    210: 0,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 53,  # 'Õ'
    214: 62,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 0,  # 'Ū'
    220: 49,  # 'Ü'
    221: 0,  # 'Ż'
    222: 64,  # 'Ž'
    223: 0,  # 'ß'
    224: 0,  # 'ą'
    225: 0,  # 'į'
    226: 0,  # 'ā'
    227: 0,  # 'ć'
    228: 19,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'ę'
    231: 0,  # 'ē'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 0,  # 'ė'
    236: 0,  # 'ģ'
    237: 0,  # 'ķ'
    238: 0,  # 'ī'
    239: 0,  # 'ļ'
    240: 54,  # 'š'
    241: 0,  # 'ń'
    242: 0,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 20,  # 'õ'
    246: 25,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 0,  # 'ū'
    252: 22,  # 'ü'
    253: 0,  # 'ż'
    254: 55,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '’'
}

ISO_8859_13_ESTONIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-13",
    language="Estonian",
    char_to_order_map=ISO_8859_13_ESTONIAN_CHAR_TO_ORDER,
    language_model=ESTONIAN_LANG_MODEL,
    typical_positive_ratio=0.9843565818346288,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÄÕÖÜäõöüŠšŽž",
)

WINDOWS_1257_ESTONIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 42,  # 'B'
    67: 44,  # 'C'
    68: 41,  # 'D'
    69: 28,  # 'E'
    70: 47,  # 'F'
    71: 48,  # 'G'
    72: 39,  # 'H'
    73: 36,  # 'I'
    74: 40,  # 'J'
    75: 24,  # 'K'
    76: 32,  # 'L'
    77: 27,  # 'M'
    78: 34,  # 'N'
    79: 38,  # 'O'
    80: 30,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 23,  # 'S'
    84: 26,  # 'T'
    85: 45,  # 'U'
    86: 33,  # 'V'
    87: 51,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 59,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 37,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 15,  # 'g'
    104: 18,  # 'h'
    105: 3,  # 'i'
    106: 17,  # 'j'
    107: 9,  # 'k'
    108: 6,  # 'l'
    109: 12,  # 'm'
    110: 8,  # 'n'
    111: 10,  # 'o'
    112: 16,  # 'p'
    113: 60,  # 'q'
    114: 13,  # 'r'
    115: 4,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 14,  # 'v'
    119: 46,  # 'w'
    120: 50,  # 'x'
    121: 43,  # 'y'
    122: 52,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.SYMBOL,  # '¨'
    142: 0,  # 'ˇ'
    143: CharacterCategory.SYMBOL,  # '¸'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.SYMBOL,  # '¯'
    158: CharacterCategory.SYMBOL,  # '˛'
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.UNDEFINED,  # None
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.UNDEFINED,  # None
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ø'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ŗ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Æ'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ø'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'ŗ'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: 0,  # 'æ'
    192: 0,  # 'Ą'
    193: 0,  # 'Į'
    194: 0,  # 'Ā'
    195: 0,  # 'Ć'
    196: 56,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Ę'
    199: 0,  # 'Ē'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ź'
    203: 0,  # 'Ė'
    204: 0,  # 'Ģ'
    205: 0,  # 'Ķ'
    206: 0,  # 'Ī'
    207: 0,  # 'Ļ'
    208: 63,  # 'Š'
    209: 0,  # 'Ń'
    210: 0,  # 'Ņ'
    211: 0,  # 'Ó'
    212: 0,  # 'Ō'
    213: 53,  # 'Õ'
    214: 62,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ų'
    217: 0,  # 'Ł'
    218: 0,  # 'Ś'
    219: 0,  # 'Ū'
    220: 49,  # 'Ü'
    221: 0,  # 'Ż'
    222: 64,  # 'Ž'
    223: 0,  # 'ß'
    224: 0,  # 'ą'
    225: 0,  # 'į'
    226: 0,  # 'ā'
    227: 0,  # 'ć'
    228: 19,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'ę'
    231: 0,  # 'ē'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ź'
    235: 0,  # 'ė'
    236: 0,  # 'ģ'
    237: 0,  # 'ķ'
    238: 0,  # 'ī'
    239: 0,  # 'ļ'
    240: 54,  # 'š'
    241: 0,  # 'ń'
    242: 0,  # 'ņ'
    243: 0,  # 'ó'
    244: 0,  # 'ō'
    245: 20,  # 'õ'
    246: 25,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ų'
    249: 0,  # 'ł'
    250: 0,  # 'ś'
    251: 0,  # 'ū'
    252: 22,  # 'ü'
    253: 0,  # 'ż'
    254: 55,  # 'ž'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1257_ESTONIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1257",
    language="Estonian",
    char_to_order_map=WINDOWS_1257_ESTONIAN_CHAR_TO_ORDER,
    language_model=ESTONIAN_LANG_MODEL,
    typical_positive_ratio=0.9843565818346288,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÄÕÖÜäõöüŠšŽž",
)
