from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

RUSSIAN_LANG_MODEL = {
    65: {  # 'Ё'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.NEGATIVE,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.NEGATIVE,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.NEGATIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.NEGATIVE,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.NEGATIVE,  # 'э'
        26: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    38: {  # 'А'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.LIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        39: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.LIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    44: {  # 'Б'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.LIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    33: {  # 'В'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    45: {  # 'Г'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    41: {  # 'Д'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    46: {  # 'Е'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        39: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.NEGATIVE,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    59: {  # 'Ж'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    48: {  # 'З'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    42: {  # 'И'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.LIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.LIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    61: {  # 'Й'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.NEGATIVE,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    35: {  # 'К'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    49: {  # 'Л'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.LIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    39: {  # 'М'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.LIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    37: {  # 'Н'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.LIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    36: {  # 'О'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.LIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.LIKELY,  # 'Г'
        41: SequenceLikelihood.LIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.LIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.LIKELY,  # 'Л'
        39: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    32: {  # 'П'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    40: {  # 'Р'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.LIKELY,  # 'У'
        51: SequenceLikelihood.LIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.LIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    34: {  # 'С'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.LIKELY,  # 'М'
        37: SequenceLikelihood.LIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.LIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.LIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    43: {  # 'Т'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.LIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.LIKELY,  # 'П'
        40: SequenceLikelihood.LIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.LIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.LIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    47: {  # 'У'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.LIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    51: {  # 'Ф'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.LIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.LIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    56: {  # 'Х'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    58: {  # 'Ц'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.LIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    53: {  # 'Ч'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.LIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    57: {  # 'Ш'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.LIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    64: {  # 'Щ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.NEGATIVE,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.NEGATIVE,  # 'л'
        12: SequenceLikelihood.NEGATIVE,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.NEGATIVE,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.NEGATIVE,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.NEGATIVE,  # 'э'
        26: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    66: {  # 'Ъ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.NEGATIVE,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.NEGATIVE,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.NEGATIVE,  # 'З'
        42: SequenceLikelihood.NEGATIVE,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        39: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.NEGATIVE,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.NEGATIVE,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.NEGATIVE,  # 'н'
        1: SequenceLikelihood.NEGATIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.NEGATIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    62: {  # 'Ы'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.NEGATIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.NEGATIVE,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.NEGATIVE,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    63: {  # 'Ь'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.NEGATIVE,  # 'а'
        20: SequenceLikelihood.NEGATIVE,  # 'б'
        9: SequenceLikelihood.NEGATIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.NEGATIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.NEGATIVE,  # 'ж'
        19: SequenceLikelihood.NEGATIVE,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.NEGATIVE,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.NEGATIVE,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.NEGATIVE,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.NEGATIVE,  # 'ч'
        27: SequenceLikelihood.NEGATIVE,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.NEGATIVE,  # 'э'
        26: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.NEGATIVE,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    52: {  # 'Э'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    60: {  # 'Ю'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    55: {  # 'Я'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.NEGATIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.NEGATIVE,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    3: {  # 'а'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    20: {  # 'б'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.POSITIVE,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    9: {  # 'в'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    21: {  # 'г'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.NEGATIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    13: {  # 'д'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.LIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    2: {  # 'е'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    25: {  # 'ж'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    19: {  # 'з'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.LIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    4: {  # 'и'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    23: {  # 'й'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    11: {  # 'к'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    10: {  # 'л'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    12: {  # 'м'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    5: {  # 'н'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    1: {  # 'о'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.LIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.POSITIVE,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    14: {  # 'п'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    8: {  # 'р'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    7: {  # 'с'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.LIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    6: {  # 'т'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.LIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    15: {  # 'у'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.LIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    30: {  # 'ф'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.LIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    24: {  # 'х'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.LIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.LIKELY,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    28: {  # 'ц'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.POSITIVE,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    22: {  # 'ч'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    27: {  # 'ш'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.POSITIVE,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.POSITIVE,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.POSITIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    29: {  # 'щ'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.NEGATIVE,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.NEGATIVE,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.NEGATIVE,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        39: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        36: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.NEGATIVE,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.POSITIVE,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.POSITIVE,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.LIKELY,  # 'у'
        30: SequenceLikelihood.NEGATIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.LIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    54: {  # 'ъ'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.NEGATIVE,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.NEGATIVE,  # 'Д'
        46: SequenceLikelihood.NEGATIVE,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.NEGATIVE,  # 'З'
        42: SequenceLikelihood.NEGATIVE,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.NEGATIVE,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        39: SequenceLikelihood.NEGATIVE,  # 'М'
        37: SequenceLikelihood.NEGATIVE,  # 'Н'
        36: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.NEGATIVE,  # 'П'
        40: SequenceLikelihood.NEGATIVE,  # 'Р'
        34: SequenceLikelihood.NEGATIVE,  # 'С'
        43: SequenceLikelihood.NEGATIVE,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.NEGATIVE,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.UNLIKELY,  # 'м'
        5: SequenceLikelihood.UNLIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.UNLIKELY,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    17: {  # 'ы'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.POSITIVE,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.POSITIVE,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    18: {  # 'ь'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.UNLIKELY,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.LIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.POSITIVE,  # 'г'
        13: SequenceLikelihood.LIKELY,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.UNLIKELY,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.LIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.UNLIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.LIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.LIKELY,  # 'ч'
        27: SequenceLikelihood.POSITIVE,  # 'ш'
        29: SequenceLikelihood.LIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.POSITIVE,  # 'я'
        50: SequenceLikelihood.LIKELY,  # 'ё'
    },
    31: {  # 'э'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.NEGATIVE,  # 'А'
        44: SequenceLikelihood.NEGATIVE,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.NEGATIVE,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.NEGATIVE,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.NEGATIVE,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.NEGATIVE,  # 'Х'
        58: SequenceLikelihood.NEGATIVE,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.NEGATIVE,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.UNLIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.POSITIVE,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.LIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.POSITIVE,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.NEGATIVE,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    26: {  # 'ю'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.UNLIKELY,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.UNLIKELY,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.LIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.LIKELY,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.LIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
    16: {  # 'я'
        65: SequenceLikelihood.NEGATIVE,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.UNLIKELY,  # 'Е'
        59: SequenceLikelihood.UNLIKELY,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.UNLIKELY,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.UNLIKELY,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.UNLIKELY,  # 'У'
        51: SequenceLikelihood.UNLIKELY,  # 'Ф'
        56: SequenceLikelihood.UNLIKELY,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.UNLIKELY,  # 'Ч'
        57: SequenceLikelihood.UNLIKELY,  # 'Ш'
        64: SequenceLikelihood.UNLIKELY,  # 'Щ'
        66: SequenceLikelihood.UNLIKELY,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.UNLIKELY,  # 'Ю'
        55: SequenceLikelihood.UNLIKELY,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.POSITIVE,  # 'б'
        9: SequenceLikelihood.POSITIVE,  # 'в'
        21: SequenceLikelihood.LIKELY,  # 'г'
        13: SequenceLikelihood.POSITIVE,  # 'д'
        2: SequenceLikelihood.POSITIVE,  # 'е'
        25: SequenceLikelihood.POSITIVE,  # 'ж'
        19: SequenceLikelihood.POSITIVE,  # 'з'
        4: SequenceLikelihood.LIKELY,  # 'и'
        23: SequenceLikelihood.LIKELY,  # 'й'
        11: SequenceLikelihood.LIKELY,  # 'к'
        10: SequenceLikelihood.POSITIVE,  # 'л'
        12: SequenceLikelihood.POSITIVE,  # 'м'
        5: SequenceLikelihood.POSITIVE,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.LIKELY,  # 'п'
        8: SequenceLikelihood.POSITIVE,  # 'р'
        7: SequenceLikelihood.POSITIVE,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.POSITIVE,  # 'х'
        28: SequenceLikelihood.POSITIVE,  # 'ц'
        22: SequenceLikelihood.POSITIVE,  # 'ч'
        27: SequenceLikelihood.LIKELY,  # 'ш'
        29: SequenceLikelihood.POSITIVE,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.UNLIKELY,  # 'ы'
        18: SequenceLikelihood.UNLIKELY,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.POSITIVE,  # 'ю'
        16: SequenceLikelihood.LIKELY,  # 'я'
        50: SequenceLikelihood.NEGATIVE,  # 'ё'
    },
    50: {  # 'ё'
        65: SequenceLikelihood.UNLIKELY,  # 'Ё'
        38: SequenceLikelihood.UNLIKELY,  # 'А'
        44: SequenceLikelihood.UNLIKELY,  # 'Б'
        33: SequenceLikelihood.UNLIKELY,  # 'В'
        45: SequenceLikelihood.UNLIKELY,  # 'Г'
        41: SequenceLikelihood.UNLIKELY,  # 'Д'
        46: SequenceLikelihood.NEGATIVE,  # 'Е'
        59: SequenceLikelihood.NEGATIVE,  # 'Ж'
        48: SequenceLikelihood.UNLIKELY,  # 'З'
        42: SequenceLikelihood.UNLIKELY,  # 'И'
        61: SequenceLikelihood.NEGATIVE,  # 'Й'
        35: SequenceLikelihood.UNLIKELY,  # 'К'
        49: SequenceLikelihood.NEGATIVE,  # 'Л'
        39: SequenceLikelihood.UNLIKELY,  # 'М'
        37: SequenceLikelihood.UNLIKELY,  # 'Н'
        36: SequenceLikelihood.UNLIKELY,  # 'О'
        32: SequenceLikelihood.UNLIKELY,  # 'П'
        40: SequenceLikelihood.UNLIKELY,  # 'Р'
        34: SequenceLikelihood.UNLIKELY,  # 'С'
        43: SequenceLikelihood.UNLIKELY,  # 'Т'
        47: SequenceLikelihood.NEGATIVE,  # 'У'
        51: SequenceLikelihood.NEGATIVE,  # 'Ф'
        56: SequenceLikelihood.NEGATIVE,  # 'Х'
        58: SequenceLikelihood.UNLIKELY,  # 'Ц'
        53: SequenceLikelihood.NEGATIVE,  # 'Ч'
        57: SequenceLikelihood.NEGATIVE,  # 'Ш'
        64: SequenceLikelihood.NEGATIVE,  # 'Щ'
        66: SequenceLikelihood.NEGATIVE,  # 'Ъ'
        62: SequenceLikelihood.NEGATIVE,  # 'Ы'
        63: SequenceLikelihood.NEGATIVE,  # 'Ь'
        52: SequenceLikelihood.UNLIKELY,  # 'Э'
        60: SequenceLikelihood.NEGATIVE,  # 'Ю'
        55: SequenceLikelihood.NEGATIVE,  # 'Я'
        3: SequenceLikelihood.UNLIKELY,  # 'а'
        20: SequenceLikelihood.UNLIKELY,  # 'б'
        9: SequenceLikelihood.LIKELY,  # 'в'
        21: SequenceLikelihood.UNLIKELY,  # 'г'
        13: SequenceLikelihood.UNLIKELY,  # 'д'
        2: SequenceLikelihood.UNLIKELY,  # 'е'
        25: SequenceLikelihood.UNLIKELY,  # 'ж'
        19: SequenceLikelihood.LIKELY,  # 'з'
        4: SequenceLikelihood.UNLIKELY,  # 'и'
        23: SequenceLikelihood.UNLIKELY,  # 'й'
        11: SequenceLikelihood.UNLIKELY,  # 'к'
        10: SequenceLikelihood.LIKELY,  # 'л'
        12: SequenceLikelihood.LIKELY,  # 'м'
        5: SequenceLikelihood.LIKELY,  # 'н'
        1: SequenceLikelihood.UNLIKELY,  # 'о'
        14: SequenceLikelihood.UNLIKELY,  # 'п'
        8: SequenceLikelihood.LIKELY,  # 'р'
        7: SequenceLikelihood.UNLIKELY,  # 'с'
        6: SequenceLikelihood.POSITIVE,  # 'т'
        15: SequenceLikelihood.UNLIKELY,  # 'у'
        30: SequenceLikelihood.UNLIKELY,  # 'ф'
        24: SequenceLikelihood.UNLIKELY,  # 'х'
        28: SequenceLikelihood.UNLIKELY,  # 'ц'
        22: SequenceLikelihood.UNLIKELY,  # 'ч'
        27: SequenceLikelihood.UNLIKELY,  # 'ш'
        29: SequenceLikelihood.UNLIKELY,  # 'щ'
        54: SequenceLikelihood.UNLIKELY,  # 'ъ'
        17: SequenceLikelihood.NEGATIVE,  # 'ы'
        18: SequenceLikelihood.NEGATIVE,  # 'ь'
        31: SequenceLikelihood.UNLIKELY,  # 'э'
        26: SequenceLikelihood.UNLIKELY,  # 'ю'
        16: SequenceLikelihood.UNLIKELY,  # 'я'
        50: SequenceLikelihood.UNLIKELY,  # 'ё'
    },
}

# Character Mapping Table(s):
CP855_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'ђ'
    129: 0,  # 'Ђ'
    130: 0,  # 'ѓ'
    131: 0,  # 'Ѓ'
    132: 50,  # 'ё'
    133: 65,  # 'Ё'
    134: 0,  # 'є'
    135: 0,  # 'Є'
    136: 0,  # 'ѕ'
    137: 0,  # 'Ѕ'
    138: 0,  # 'і'
    139: 0,  # 'І'
    140: 0,  # 'ї'
    141: 0,  # 'Ї'
    142: 0,  # 'ј'
    143: 0,  # 'Ј'
    144: 0,  # 'љ'
    145: 0,  # 'Љ'
    146: 0,  # 'њ'
    147: 0,  # 'Њ'
    148: 0,  # 'ћ'
    149: 0,  # 'Ћ'
    150: 0,  # 'ќ'
    151: 0,  # 'Ќ'
    152: 0,  # 'ў'
    153: 0,  # 'Ў'
    154: 0,  # 'џ'
    155: 0,  # 'Џ'
    156: 26,  # 'ю'
    157: 60,  # 'Ю'
    158: 54,  # 'ъ'
    159: 66,  # 'Ъ'
    160: 3,  # 'а'
    161: 38,  # 'А'
    162: 20,  # 'б'
    163: 44,  # 'Б'
    164: 28,  # 'ц'
    165: 58,  # 'Ц'
    166: 13,  # 'д'
    167: 41,  # 'Д'
    168: 2,  # 'е'
    169: 46,  # 'Е'
    170: 30,  # 'ф'
    171: 51,  # 'Ф'
    172: 21,  # 'г'
    173: 45,  # 'Г'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 24,  # 'х'
    182: 56,  # 'Х'
    183: 4,  # 'и'
    184: 42,  # 'И'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 23,  # 'й'
    190: 61,  # 'Й'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 11,  # 'к'
    199: 35,  # 'К'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 10,  # 'л'
    209: 49,  # 'Л'
    210: 12,  # 'м'
    211: 39,  # 'М'
    212: 5,  # 'н'
    213: 37,  # 'Н'
    214: 1,  # 'о'
    215: 36,  # 'О'
    216: 14,  # 'п'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 32,  # 'П'
    222: 16,  # 'я'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 55,  # 'Я'
    225: 8,  # 'р'
    226: 40,  # 'Р'
    227: 7,  # 'с'
    228: 34,  # 'С'
    229: 6,  # 'т'
    230: 43,  # 'Т'
    231: 15,  # 'у'
    232: 47,  # 'У'
    233: 25,  # 'ж'
    234: 59,  # 'Ж'
    235: 9,  # 'в'
    236: 33,  # 'В'
    237: 18,  # 'ь'
    238: 63,  # 'Ь'
    239: CharacterCategory.SYMBOL,  # '№'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: 17,  # 'ы'
    242: 62,  # 'Ы'
    243: 19,  # 'з'
    244: 48,  # 'З'
    245: 27,  # 'ш'
    246: 57,  # 'Ш'
    247: 31,  # 'э'
    248: 52,  # 'Э'
    249: 29,  # 'щ'
    250: 64,  # 'Щ'
    251: 22,  # 'ч'
    252: 53,  # 'Ч'
    253: CharacterCategory.SYMBOL,  # '§'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP855_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP855",
    language="Russian",
    char_to_order_map=CP855_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)

CP866_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 38,  # 'А'
    129: 44,  # 'Б'
    130: 33,  # 'В'
    131: 45,  # 'Г'
    132: 41,  # 'Д'
    133: 46,  # 'Е'
    134: 59,  # 'Ж'
    135: 48,  # 'З'
    136: 0,  # 'И'
    137: 61,  # 'Й'
    138: 35,  # 'К'
    139: 49,  # 'Л'
    140: 39,  # 'М'
    141: 37,  # 'Н'
    142: 36,  # 'О'
    143: 32,  # 'П'
    144: 40,  # 'Р'
    145: 34,  # 'С'
    146: 43,  # 'Т'
    147: 47,  # 'У'
    148: 51,  # 'Ф'
    149: 56,  # 'Х'
    150: 58,  # 'Ц'
    151: 53,  # 'Ч'
    152: 57,  # 'Ш'
    153: 64,  # 'Щ'
    154: 66,  # 'Ъ'
    155: 62,  # 'Ы'
    156: 63,  # 'Ь'
    157: 52,  # 'Э'
    158: 60,  # 'Ю'
    159: 55,  # 'Я'
    160: 3,  # 'а'
    161: 20,  # 'б'
    162: 9,  # 'в'
    163: 21,  # 'г'
    164: 13,  # 'д'
    165: 2,  # 'е'
    166: 25,  # 'ж'
    167: 19,  # 'з'
    168: 0,  # 'и'
    169: 23,  # 'й'
    170: 11,  # 'к'
    171: 10,  # 'л'
    172: 12,  # 'м'
    173: 5,  # 'н'
    174: 1,  # 'о'
    175: 14,  # 'п'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 8,  # 'р'
    225: 7,  # 'с'
    226: 6,  # 'т'
    227: 15,  # 'у'
    228: 30,  # 'ф'
    229: 24,  # 'х'
    230: 28,  # 'ц'
    231: 22,  # 'ч'
    232: 27,  # 'ш'
    233: 29,  # 'щ'
    234: 54,  # 'ъ'
    235: 17,  # 'ы'
    236: 18,  # 'ь'
    237: 31,  # 'э'
    238: 26,  # 'ю'
    239: 16,  # 'я'
    240: 65,  # 'Ё'
    241: 50,  # 'ё'
    242: 0,  # 'Є'
    243: 0,  # 'є'
    244: 0,  # 'Ї'
    245: 0,  # 'ї'
    246: 0,  # 'Ў'
    247: 0,  # 'ў'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: CharacterCategory.SYMBOL,  # '№'
    253: CharacterCategory.SYMBOL,  # '¤'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP866_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP866",
    language="Russian",
    char_to_order_map=CP866_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)

ISO_8859_5_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 65,  # 'Ё'
    162: 0,  # 'Ђ'
    163: 0,  # 'Ѓ'
    164: 0,  # 'Є'
    165: 0,  # 'Ѕ'
    166: 0,  # 'І'
    167: 0,  # 'Ї'
    168: 0,  # 'Ј'
    169: 0,  # 'Љ'
    170: 0,  # 'Њ'
    171: 0,  # 'Ћ'
    172: 0,  # 'Ќ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ў'
    175: 0,  # 'Џ'
    176: 38,  # 'А'
    177: 44,  # 'Б'
    178: 33,  # 'В'
    179: 45,  # 'Г'
    180: 41,  # 'Д'
    181: 46,  # 'Е'
    182: 59,  # 'Ж'
    183: 48,  # 'З'
    184: 42,  # 'И'
    185: 61,  # 'Й'
    186: 35,  # 'К'
    187: 49,  # 'Л'
    188: 39,  # 'М'
    189: 37,  # 'Н'
    190: 36,  # 'О'
    191: 32,  # 'П'
    192: 40,  # 'Р'
    193: 34,  # 'С'
    194: 43,  # 'Т'
    195: 47,  # 'У'
    196: 51,  # 'Ф'
    197: 56,  # 'Х'
    198: 58,  # 'Ц'
    199: 53,  # 'Ч'
    200: 57,  # 'Ш'
    201: 64,  # 'Щ'
    202: 66,  # 'Ъ'
    203: 62,  # 'Ы'
    204: 63,  # 'Ь'
    205: 52,  # 'Э'
    206: 60,  # 'Ю'
    207: 55,  # 'Я'
    208: 3,  # 'а'
    209: 20,  # 'б'
    210: 9,  # 'в'
    211: 21,  # 'г'
    212: 13,  # 'д'
    213: 2,  # 'е'
    214: 25,  # 'ж'
    215: 19,  # 'з'
    216: 4,  # 'и'
    217: 23,  # 'й'
    218: 11,  # 'к'
    219: 10,  # 'л'
    220: 12,  # 'м'
    221: 5,  # 'н'
    222: 1,  # 'о'
    223: 14,  # 'п'
    224: 8,  # 'р'
    225: 7,  # 'с'
    226: 6,  # 'т'
    227: 15,  # 'у'
    228: 30,  # 'ф'
    229: 24,  # 'х'
    230: 28,  # 'ц'
    231: 22,  # 'ч'
    232: 27,  # 'ш'
    233: 29,  # 'щ'
    234: 54,  # 'ъ'
    235: 17,  # 'ы'
    236: 18,  # 'ь'
    237: 31,  # 'э'
    238: 26,  # 'ю'
    239: 16,  # 'я'
    240: CharacterCategory.SYMBOL,  # '№'
    241: 50,  # 'ё'
    242: 0,  # 'ђ'
    243: 0,  # 'ѓ'
    244: 0,  # 'є'
    245: 0,  # 'ѕ'
    246: 0,  # 'і'
    247: 0,  # 'ї'
    248: 0,  # 'ј'
    249: 0,  # 'љ'
    250: 0,  # 'њ'
    251: 0,  # 'ћ'
    252: 0,  # 'ќ'
    253: CharacterCategory.SYMBOL,  # '§'
    254: 0,  # 'ў'
    255: 0,  # 'џ'
}

ISO_8859_5_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-5",
    language="Russian",
    char_to_order_map=ISO_8859_5_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)

KOI8_R_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '─'
    129: CharacterCategory.SYMBOL,  # '│'
    130: CharacterCategory.SYMBOL,  # '┌'
    131: CharacterCategory.SYMBOL,  # '┐'
    132: CharacterCategory.SYMBOL,  # '└'
    133: CharacterCategory.SYMBOL,  # '┘'
    134: CharacterCategory.SYMBOL,  # '├'
    135: CharacterCategory.SYMBOL,  # '┤'
    136: CharacterCategory.SYMBOL,  # '┬'
    137: CharacterCategory.SYMBOL,  # '┴'
    138: CharacterCategory.SYMBOL,  # '┼'
    139: CharacterCategory.SYMBOL,  # '▀'
    140: CharacterCategory.SYMBOL,  # '▄'
    141: CharacterCategory.SYMBOL,  # '█'
    142: CharacterCategory.SYMBOL,  # '▌'
    143: CharacterCategory.SYMBOL,  # '▐'
    144: CharacterCategory.SYMBOL,  # '░'
    145: CharacterCategory.SYMBOL,  # '▒'
    146: CharacterCategory.SYMBOL,  # '▓'
    147: CharacterCategory.SYMBOL,  # '⌠'
    148: CharacterCategory.SYMBOL,  # '■'
    149: CharacterCategory.SYMBOL,  # '∙'
    150: CharacterCategory.SYMBOL,  # '√'
    151: CharacterCategory.SYMBOL,  # '≈'
    152: CharacterCategory.SYMBOL,  # '≤'
    153: CharacterCategory.SYMBOL,  # '≥'
    154: CharacterCategory.CONTROL,  # '\xa0'
    155: CharacterCategory.SYMBOL,  # '⌡'
    156: CharacterCategory.SYMBOL,  # '°'
    157: CharacterCategory.DIGIT,  # '²'
    158: CharacterCategory.SYMBOL,  # '·'
    159: CharacterCategory.SYMBOL,  # '÷'
    160: CharacterCategory.SYMBOL,  # '═'
    161: CharacterCategory.SYMBOL,  # '║'
    162: CharacterCategory.SYMBOL,  # '╒'
    163: 50,  # 'ё'
    164: CharacterCategory.SYMBOL,  # '╓'
    165: CharacterCategory.SYMBOL,  # '╔'
    166: CharacterCategory.SYMBOL,  # '╕'
    167: CharacterCategory.SYMBOL,  # '╖'
    168: CharacterCategory.SYMBOL,  # '╗'
    169: CharacterCategory.SYMBOL,  # '╘'
    170: CharacterCategory.SYMBOL,  # '╙'
    171: CharacterCategory.SYMBOL,  # '╚'
    172: CharacterCategory.SYMBOL,  # '╛'
    173: CharacterCategory.SYMBOL,  # '╜'
    174: CharacterCategory.SYMBOL,  # '╝'
    175: CharacterCategory.SYMBOL,  # '╞'
    176: CharacterCategory.SYMBOL,  # '╟'
    177: CharacterCategory.SYMBOL,  # '╠'
    178: CharacterCategory.SYMBOL,  # '╡'
    179: 65,  # 'Ё'
    180: CharacterCategory.SYMBOL,  # '╢'
    181: CharacterCategory.SYMBOL,  # '╣'
    182: CharacterCategory.SYMBOL,  # '╤'
    183: CharacterCategory.SYMBOL,  # '╥'
    184: CharacterCategory.SYMBOL,  # '╦'
    185: CharacterCategory.SYMBOL,  # '╧'
    186: CharacterCategory.SYMBOL,  # '╨'
    187: CharacterCategory.SYMBOL,  # '╩'
    188: CharacterCategory.SYMBOL,  # '╪'
    189: CharacterCategory.SYMBOL,  # '╫'
    190: CharacterCategory.SYMBOL,  # '╬'
    191: CharacterCategory.SYMBOL,  # '©'
    192: 26,  # 'ю'
    193: 3,  # 'а'
    194: 20,  # 'б'
    195: 28,  # 'ц'
    196: 13,  # 'д'
    197: 2,  # 'е'
    198: 30,  # 'ф'
    199: 21,  # 'г'
    200: 24,  # 'х'
    201: 4,  # 'и'
    202: 23,  # 'й'
    203: 11,  # 'к'
    204: 10,  # 'л'
    205: 12,  # 'м'
    206: 5,  # 'н'
    207: 1,  # 'о'
    208: 14,  # 'п'
    209: 16,  # 'я'
    210: 8,  # 'р'
    211: 7,  # 'с'
    212: 6,  # 'т'
    213: 15,  # 'у'
    214: 25,  # 'ж'
    215: 9,  # 'в'
    216: 18,  # 'ь'
    217: 17,  # 'ы'
    218: 19,  # 'з'
    219: 27,  # 'ш'
    220: 31,  # 'э'
    221: 29,  # 'щ'
    222: 22,  # 'ч'
    223: 54,  # 'ъ'
    224: 60,  # 'Ю'
    225: 38,  # 'А'
    226: 44,  # 'Б'
    227: 58,  # 'Ц'
    228: 41,  # 'Д'
    229: 46,  # 'Е'
    230: 51,  # 'Ф'
    231: 45,  # 'Г'
    232: 56,  # 'Х'
    233: 42,  # 'И'
    234: 61,  # 'Й'
    235: 35,  # 'К'
    236: 49,  # 'Л'
    237: 39,  # 'М'
    238: 37,  # 'Н'
    239: 36,  # 'О'
    240: 32,  # 'П'
    241: 55,  # 'Я'
    242: 40,  # 'Р'
    243: 34,  # 'С'
    244: 43,  # 'Т'
    245: 47,  # 'У'
    246: 59,  # 'Ж'
    247: 33,  # 'В'
    248: 63,  # 'Ь'
    249: 62,  # 'Ы'
    250: 48,  # 'З'
    251: 57,  # 'Ш'
    252: 52,  # 'Э'
    253: 64,  # 'Щ'
    254: 53,  # 'Ч'
    255: 66,  # 'Ъ'
}

KOI8_R_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="KOI8-R",
    language="Russian",
    char_to_order_map=KOI8_R_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)

MACCYRILLIC_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 38,  # 'А'
    129: 44,  # 'Б'
    130: 33,  # 'В'
    131: 45,  # 'Г'
    132: 41,  # 'Д'
    133: 46,  # 'Е'
    134: 59,  # 'Ж'
    135: 48,  # 'З'
    136: 42,  # 'И'
    137: 61,  # 'Й'
    138: 35,  # 'К'
    139: 49,  # 'Л'
    140: 39,  # 'М'
    141: 37,  # 'Н'
    142: 36,  # 'О'
    143: 32,  # 'П'
    144: 40,  # 'Р'
    145: 34,  # 'С'
    146: 43,  # 'Т'
    147: 47,  # 'У'
    148: 51,  # 'Ф'
    149: 56,  # 'Х'
    150: 58,  # 'Ц'
    151: 53,  # 'Ч'
    152: 57,  # 'Ш'
    153: 64,  # 'Щ'
    154: 66,  # 'Ъ'
    155: 62,  # 'Ы'
    156: 63,  # 'Ь'
    157: 52,  # 'Э'
    158: 60,  # 'Ю'
    159: 55,  # 'Я'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ґ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'І'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'Ђ'
    172: 0,  # 'ђ'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Ѓ'
    175: 0,  # 'ѓ'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'і'
    181: 0,  # 'µ'
    182: 0,  # 'ґ'
    183: 0,  # 'Ј'
    184: 0,  # 'Є'
    185: 0,  # 'є'
    186: 0,  # 'Ї'
    187: 0,  # 'ї'
    188: 0,  # 'Љ'
    189: 0,  # 'љ'
    190: 0,  # 'Њ'
    191: 0,  # 'њ'
    192: 0,  # 'ј'
    193: 0,  # 'Ѕ'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'Ћ'
    204: 0,  # 'ћ'
    205: 0,  # 'Ќ'
    206: 0,  # 'ќ'
    207: 0,  # 'ѕ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '„'
    216: 0,  # 'Ў'
    217: 0,  # 'ў'
    218: 0,  # 'Џ'
    219: 0,  # 'џ'
    220: CharacterCategory.SYMBOL,  # '№'
    221: 65,  # 'Ё'
    222: 50,  # 'ё'
    223: 16,  # 'я'
    224: 3,  # 'а'
    225: 20,  # 'б'
    226: 9,  # 'в'
    227: 21,  # 'г'
    228: 13,  # 'д'
    229: 2,  # 'е'
    230: 25,  # 'ж'
    231: 19,  # 'з'
    232: 4,  # 'и'
    233: 23,  # 'й'
    234: 11,  # 'к'
    235: 10,  # 'л'
    236: 12,  # 'м'
    237: 5,  # 'н'
    238: 1,  # 'о'
    239: 14,  # 'п'
    240: 8,  # 'р'
    241: 7,  # 'с'
    242: 6,  # 'т'
    243: 15,  # 'у'
    244: 30,  # 'ф'
    245: 24,  # 'х'
    246: 28,  # 'ц'
    247: 22,  # 'ч'
    248: 27,  # 'ш'
    249: 29,  # 'щ'
    250: 54,  # 'ъ'
    251: 17,  # 'ы'
    252: 18,  # 'ь'
    253: 31,  # 'э'
    254: 26,  # 'ю'
    255: CharacterCategory.SYMBOL,  # '€'
}

MACCYRILLIC_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacCyrillic",
    language="Russian",
    char_to_order_map=MACCYRILLIC_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)

WINDOWS_1251_RUSSIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ђ'
    129: 0,  # 'Ѓ'
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ѓ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.SYMBOL,  # '€'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Љ'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Њ'
    141: 0,  # 'Ќ'
    142: 0,  # 'Ћ'
    143: 0,  # 'Џ'
    144: 0,  # 'ђ'
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'љ'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'њ'
    157: 0,  # 'ќ'
    158: 0,  # 'ћ'
    159: 0,  # 'џ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ў'
    162: 0,  # 'ў'
    163: 0,  # 'Ј'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ґ'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 65,  # 'Ё'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Є'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ї'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'І'
    179: 0,  # 'і'
    180: 0,  # 'ґ'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 50,  # 'ё'
    185: CharacterCategory.SYMBOL,  # '№'
    186: 0,  # 'є'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'ј'
    189: 0,  # 'Ѕ'
    190: 0,  # 'ѕ'
    191: 0,  # 'ї'
    192: 38,  # 'А'
    193: 44,  # 'Б'
    194: 33,  # 'В'
    195: 45,  # 'Г'
    196: 41,  # 'Д'
    197: 46,  # 'Е'
    198: 59,  # 'Ж'
    199: 48,  # 'З'
    200: 42,  # 'И'
    201: 61,  # 'Й'
    202: 35,  # 'К'
    203: 49,  # 'Л'
    204: 39,  # 'М'
    205: 37,  # 'Н'
    206: 36,  # 'О'
    207: 32,  # 'П'
    208: 40,  # 'Р'
    209: 34,  # 'С'
    210: 43,  # 'Т'
    211: 47,  # 'У'
    212: 51,  # 'Ф'
    213: 56,  # 'Х'
    214: 58,  # 'Ц'
    215: 53,  # 'Ч'
    216: 57,  # 'Ш'
    217: 64,  # 'Щ'
    218: 66,  # 'Ъ'
    219: 62,  # 'Ы'
    220: 63,  # 'Ь'
    221: 52,  # 'Э'
    222: 60,  # 'Ю'
    223: 55,  # 'Я'
    224: 3,  # 'а'
    225: 20,  # 'б'
    226: 9,  # 'в'
    227: 21,  # 'г'
    228: 13,  # 'д'
    229: 2,  # 'е'
    230: 25,  # 'ж'
    231: 19,  # 'з'
    232: 4,  # 'и'
    233: 23,  # 'й'
    234: 11,  # 'к'
    235: 10,  # 'л'
    236: 12,  # 'м'
    237: 5,  # 'н'
    238: 1,  # 'о'
    239: 14,  # 'п'
    240: 8,  # 'р'
    241: 7,  # 'с'
    242: 6,  # 'т'
    243: 15,  # 'у'
    244: 30,  # 'ф'
    245: 24,  # 'х'
    246: 28,  # 'ц'
    247: 22,  # 'ч'
    248: 27,  # 'ш'
    249: 29,  # 'щ'
    250: 54,  # 'ъ'
    251: 17,  # 'ы'
    252: 18,  # 'ь'
    253: 31,  # 'э'
    254: 26,  # 'ю'
    255: 16,  # 'я'
}

WINDOWS_1251_RUSSIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1251",
    language="Russian",
    char_to_order_map=WINDOWS_1251_RUSSIAN_CHAR_TO_ORDER,
    language_model=RUSSIAN_LANG_MODEL,
    typical_positive_ratio=0.9732509289668491,
    keep_ascii_letters=False,
    alphabet="ЁАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюяё",
)
