import type * as Models from "../../../models";
import type { BroadcastAddress } from "../../../zspec/enums";
import * as Zcl from "../../../zspec/zcl";
import * as Zdo from "../../../zspec/zdo";
import type * as ZdoTypes from "../../../zspec/zdo/definition/tstypes";
import Adapter from "../../adapter";
import type * as Events from "../../events";
import type { AdapterOptions, CoordinatorVersion, NetworkOptions, NetworkParameters, SerialPortOptions, StartResult } from "../../tstype";
export declare class DeconzAdapter extends Adapter {
    private driver;
    private openRequestsQueue;
    private frameParserEvent;
    private fwVersion?;
    private waitress;
    private joinPermitted;
    constructor(networkOptions: NetworkOptions, serialPortOptions: SerialPortOptions, backupPath: string, adapterOptions: AdapterOptions);
    /**
     * Adapter methods
     */
    start(): Promise<StartResult>;
    stop(): Promise<void>;
    getCoordinatorIEEE(): Promise<string>;
    permitJoin(seconds: number, networkAddress?: number): Promise<void>;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    addInstallCode(ieeeAddress: string, key: Buffer, hashed: boolean): Promise<void>;
    reset(_type: "soft" | "hard"): Promise<void>;
    waitFor(networkAddress: number | undefined, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number | undefined, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    sendZdo(ieeeAddress: string, networkAddress: number, clusterId: Zdo.ClusterId, payload: Buffer, disableResponse: true): Promise<void>;
    sendZdo<K extends keyof ZdoTypes.RequestToResponseMap>(ieeeAddress: string, networkAddress: number, clusterId: K, payload: Buffer, disableResponse: false): Promise<ZdoTypes.RequestToResponseMap[K]>;
    sendZclFrameToEndpoint(_ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, _disableRecovery: boolean, sourceEndpoint?: number, profileId?: number): Promise<Events.ZclPayload | undefined>;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame, sourceEndpoint?: number, profileId?: number): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress, profileId?: number): Promise<void>;
    supportsBackup(): Promise<boolean>;
    /**
     * Loads currently stored backup and returns it in internal backup model.
     */
    private getStoredBackup;
    backup(): Promise<Models.Backup>;
    getNetworkParameters(): Promise<NetworkParameters>;
    restoreChannelInterPAN(): Promise<void>;
    sendZclFrameInterPANToIeeeAddr(_zclFrame: Zcl.Frame, _ieeeAddr: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number, disableResponse: false): Promise<Events.ZclPayload>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number, disableResponse: true): Promise<undefined>;
    sendZclFrameInterPANBroadcastWithResponse(_zclFrame: Zcl.Frame, _timeout: number): Promise<Events.ZclPayload>;
    setChannelInterPAN(_channel: number): Promise<void>;
    sendZclFrameInterPANIeeeAddr(_zclFrame: Zcl.Frame, _ieeeAddr: string): Promise<void>;
    /**
     * Private methods
     */
    private waitForData;
    private checkReceivedGreenPowerIndication;
    private checkWaitForDataRequestTimeouts;
    private checkReceivedDataPayload;
    private nextTransactionID;
    private waitressTimeoutFormatter;
    private waitressValidator;
}
//# sourceMappingURL=deconzAdapter.d.ts.map