/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/**
 * Representing a Server Variable for server URL template substitution.
 */
#ifndef QOAI_SERVERVARIABLE_H
#define QOAI_SERVERVARIABLE_H

#include "openapicommoncommonexports.h"

#include <QtCore/qcontainerfwd.h>
#include <QtCore/qshareddata.h>

QT_BEGIN_NAMESPACE

namespace QtOpenApiCommon {

class QOAIServerVariablePrivate;
class QOAIServerVariable {
public:
    enum class ServerError
    {
        NoError = 0, // Success
        ServerVariableNotFound = -1,
        EnumValueNotFound = -2,   // The value is not defined in m_enumValues
        OperationNotFound = -3,
        ServerIndexNotFound = -4,
    };

    /**
     * @param description A description for the server variable.
     * @param defaultValue The default value to use for substitution.
     * @param enumValues An enumeration of string values to be used if the substitution options are from a limited set.
     */
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerVariable(const QString &description, const QString &defaultValue, const QSet<QString> &enumValues);

    OPENAPICOMMON_COMMON_EXPORT QOAIServerVariable();
    OPENAPICOMMON_COMMON_EXPORT ~QOAIServerVariable();

    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerVariable(const QOAIServerVariable &other);
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerVariable &operator=(const QOAIServerVariable &other);

    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerVariable(QOAIServerVariable &&other) noexcept;
    OPENAPICOMMON_COMMON_EXPORT
    QOAIServerVariable &operator=(QOAIServerVariable &&other) noexcept;

    OPENAPICOMMON_COMMON_EXPORT void swap(QOAIServerVariable &other) noexcept;

    OPENAPICOMMON_COMMON_EXPORT ServerError setValue(const QString& value);

    OPENAPICOMMON_COMMON_EXPORT QString value() const;
    OPENAPICOMMON_COMMON_EXPORT QSet<QString> enumValues() const;
    OPENAPICOMMON_COMMON_EXPORT QString description() const;

private:
    OPENAPICOMMON_COMMON_EXPORT friend bool
    comparesEqual(const QOAIServerVariable &lhs, const QOAIServerVariable &rhs) noexcept;

    friend bool
    operator==(const QOAIServerVariable &lhs, const QOAIServerVariable &rhs) noexcept
    { return comparesEqual(lhs, rhs); }
    friend bool
    operator!=(const QOAIServerVariable &lhs, const QOAIServerVariable &rhs) noexcept
    { return !comparesEqual(lhs, rhs); }

    friend size_t qHash(const QOAIServerVariable &value) = delete;
    friend size_t qHash(const QOAIServerVariable &value, size_t seed) = delete;

    QExplicitlySharedDataPointer<QOAIServerVariablePrivate> d_ptr;
};

} // namespace QtOpenApiCommon

QT_END_NAMESPACE

#endif // QOAI_SERVERVARIABLE_H
