#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-G1AIOdLxxa57rZxSSNMDxq
key:                  arch-hs-0.12.0.3-G1AIOdLxxa57rZxSSNMDxq
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  46d835771475d0acedf02e0c632e196a
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-G1AIOdLxxa57rZxSSNMDxq
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-BCWGZ4JsbfNAEOmzFgneWv
    aeson-2.1.2.1-9HQxGJjc2cdAmcsURaBDXL
    algebraic-graphs-0.7-6hwGv0yNr1tDCi0aOhHJDx
    arch-web-0.3.1-COFI8OdcxvAFnfgWdEqDlN base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-5ZSsm3oucHaEmMgze2N1VX
    conduit-extra-1.3.8-EHeHJbVBqalFyMROhCo19c containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-BZHRFc6ks0nBzNqMsVQXTE
    http-client-0.7.18-4azb2VpvphD76ORXsCoGJ
    http-client-tls-0.3.6.4-LOLsrWs0M1J51uLjGvwA1
    megaparsec-9.7.0-InMnv3t1CSe1tTlGcmutcd
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-HR32ToPsj4Y3qyQhvdEr8F
    optparse-simple-0.1.1.4-GNcCSIcsOkmF8JuJ9Z0u5l
    polysemy-1.9.2.0-2muhVloBlST9AnEOl0I0re
    prettyprinter-1.7.1-HfOhWgFDXrQ8Fhf8BimOva
    prettyprinter-ansi-terminal-1.1.3-A1yMFsmhb7lBpUsDgDXiNV
    servant-client-0.20.2-6qMmBNBVGcdB4WUAODAr0
    split-0.2.5-JwWMTmXvu7fChkavPTERve
    tar-conduit-0.4.1-4Td0RL6aUi889lZJaRV88k template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

