#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-Bn9RdWbuXFLKsjCqNkOrpt
key:                  arch-hs-0.12.0.4-Bn9RdWbuXFLKsjCqNkOrpt
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  7d910d396b4acaff08b3a0fc16a21a82
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-Bn9RdWbuXFLKsjCqNkOrpt
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.5-KcBV17wTopECmrGDZnnXHj
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig
    algebraic-graphs-0.7-7CMZDLdLaSIDMCHRMn3QOY
    arch-web-0.3.1-Kfk0k8yZYBEBdV6GM3ijLx base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-3M1B5TjJPZk646ipFSI00d
    conduit-extra-1.3.8-BV0bH3FRcPVLYpMYNDmntB containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-Lb7E51wOkHUH7yrjzKNfM5
    http-client-0.7.19-2IAKaL0RajRLDWsZpaLmo9
    http-client-tls-0.3.6.4-1BDRKQL1P8oJwrUsm96xXK
    megaparsec-9.7.0-G88a36osNzSFo1446urB6s
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-3gcOtg3BgJb2l2Gav4rshF
    optparse-simple-0.1.1.4-2ZXEnTplT1rCVh6bomZ6EC
    polysemy-1.9.2.0-1YjKEsCazNbLlNn46RBwaV
    prettyprinter-1.7.1-7LCr279S4u97FneESew6z
    prettyprinter-ansi-terminal-1.1.3-9QGQBbp5h95K5T1zzYNOLO
    servant-client-0.20.3.0-FL6ih1rjS5a75zHUoW4Qbq
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK
    tar-conduit-0.4.1-2tio4OABPjACh5470C9dHb template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

