#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-BlT2SXPmSQAIzASDJEtva7
key:                  arch-hs-0.12.1-BlT2SXPmSQAIzASDJEtva7
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  e5dc9917dd33c65ea33811469430768e
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-BlT2SXPmSQAIzASDJEtva7
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-A8nvOVmSsh0JkAblhshgiC
    aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol
    algebraic-graphs-0.7-55LUyyc9RB0AgsMfuOz8nP
    arch-web-0.3.2-4v2JoGec4PxEyiKDyYwut1 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-GPe8u3RYhCEKxuB1doj8qM
    conduit-extra-1.3.8-H0Ux7lWGa6s1NvcyXyCw5o containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-ABEL0v7dGAsDPNWBilGuCh
    http-client-0.7.19-ItVvZ8PodQhKrjwqBcCUYZ
    http-client-tls-0.3.6.4-CEK6krdvlVv4rw49kLfgyN
    megaparsec-9.7.0-30CmWzNYqun9hcXpVgYg36
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-5Hr94RFlA7t8MH3M0OJHxj
    optparse-simple-0.1.1.4-IWKjjltiToOEiIUuMbWqcL
    polysemy-1.9.2.0-9k0cfkUpyKDADIUbhqbgSI
    prettyprinter-1.7.1-AF4Gt6IhKUy3k7s13EBNuD
    prettyprinter-ansi-terminal-1.1.3-FQisb84CsPW4gsLLZgiBMq
    servant-client-0.20.3.0-FDNwwhLGJzu1EcwxfRQ5So
    split-0.2.5-Jw4n4gsdaZK4FHILOCxPWx
    tar-conduit-0.4.1-B6AdfBjCtWcFtkTYb5HuN0 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

