#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-HA215gnYMjC8qhHAExjeOE
key:                  arch-hs-0.12.1-HA215gnYMjC8qhHAExjeOE
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  184d538111567deeca143e8332dd5986
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-HA215gnYMjC8qhHAExjeOE
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-E8Q2BRELLWW2rpraq45tI3
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    algebraic-graphs-0.7-GvflYrq2OnHKCgmZZYz28e
    arch-web-0.3.2-5KNrZKoVa0mBeTpMoMgPKl base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-P2VVzWMvOMICi7Nj7BTmx
    conduit-extra-1.3.8-4zxXchcBeveL56hfIzolRA containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-EOMJvmqgqGUF6wa55iiNWJ
    http-client-0.7.19-9qUcwTVQqbvEShQpYcde6b
    http-client-tls-0.3.6.4-KN3JTiWE2EI1kyisYRtf57
    megaparsec-9.7.0-3LaPBNRfEWMD5TdaoQ3jm0
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-1ZcT6r01v9R1WH25f7xLR9
    optparse-simple-0.1.1.4-AEOiJqywXPqIZkj8AXVQzL
    polysemy-1.9.2.0-owThLyknOfClkW7HC7LPl
    prettyprinter-1.7.1-80F1dUtwFWzDp5CT3ZZVKz
    prettyprinter-ansi-terminal-1.1.3-IaiwJGU5h7gDXHX3Nxd5K0
    servant-client-0.20.3.0-6By6SnQfKgr8dYx76XJYOt
    split-0.2.5-eIzaXXEViC764D7Uvb52H
    tar-conduit-0.4.1-HndfooNbnVOIQ0YCAhUfu3 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

