#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-DLZXTUiT0e61StffZ238KI
key:                  arch-hs-0.12.1-DLZXTUiT0e61StffZ238KI
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  71e45cb3aa9f8ef8b8b8cf3629b3b7fc
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-DLZXTUiT0e61StffZ238KI
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-ISsha3r0HNr6M4FXs44tpp
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    algebraic-graphs-0.7-FQSjUTwua0FANn7LfORY1t
    arch-web-0.3.2-3CCo9jZda0hHNVr9OqOPxf base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-Iv674JaqEE17PR7slCoUfp
    conduit-extra-1.3.8-9BT5gTgmegiEww1RLwnr5K containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-L7HICUKY7c45or1xfXEJQD
    http-client-0.7.19-LRfftiQ6YWX88xW4fFXEK8
    http-client-tls-0.3.6.4-3SOG6pMBD126OroBvnbwcp
    megaparsec-9.7.0-7jzSygYb9UCHSxVBa30IvK
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-Kwx03Iroq0M8UcJ8mpPiCU
    optparse-simple-0.1.1.4-IfzGjQ7CwMoKR2mZP2SV7V
    polysemy-1.9.2.0-GZH9LnIJaHs7aT7kV6Nrp9
    prettyprinter-1.7.1-AIJZZXuo91NCViNpmKNzcQ
    prettyprinter-ansi-terminal-1.1.3-zpJIE64fpCIqSqesY8J9j
    servant-client-0.20.3.0-CIQAhKa7TNAJ5WrqPN222y
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-FV4jiIRsd7lJiY5rn2EkIj template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

