﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ecs/ECS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace ECS
{
namespace Model
{
  enum class TargetType
  {
    NOT_SET,
    container_instance
  };

namespace TargetTypeMapper
{
AWS_ECS_API TargetType GetTargetTypeForName(const Aws::String& name);

AWS_ECS_API Aws::String GetNameForTargetType(TargetType value);
} // namespace TargetTypeMapper
} // namespace Model
} // namespace ECS
} // namespace Aws
