﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{
  class DescribeSecurityHubV2Result
  {
  public:
    AWS_SECURITYHUB_API DescribeSecurityHubV2Result() = default;
    AWS_SECURITYHUB_API DescribeSecurityHubV2Result(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_SECURITYHUB_API DescribeSecurityHubV2Result& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The ARN of the service resource.</p>
     */
    inline const Aws::String& GetHubV2Arn() const { return m_hubV2Arn; }
    template<typename HubV2ArnT = Aws::String>
    void SetHubV2Arn(HubV2ArnT&& value) { m_hubV2ArnHasBeenSet = true; m_hubV2Arn = std::forward<HubV2ArnT>(value); }
    template<typename HubV2ArnT = Aws::String>
    DescribeSecurityHubV2Result& WithHubV2Arn(HubV2ArnT&& value) { SetHubV2Arn(std::forward<HubV2ArnT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date and time when the service was enabled in the account.</p>
     */
    inline const Aws::String& GetSubscribedAt() const { return m_subscribedAt; }
    template<typename SubscribedAtT = Aws::String>
    void SetSubscribedAt(SubscribedAtT&& value) { m_subscribedAtHasBeenSet = true; m_subscribedAt = std::forward<SubscribedAtT>(value); }
    template<typename SubscribedAtT = Aws::String>
    DescribeSecurityHubV2Result& WithSubscribedAt(SubscribedAtT&& value) { SetSubscribedAt(std::forward<SubscribedAtT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    DescribeSecurityHubV2Result& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_hubV2Arn;
    bool m_hubV2ArnHasBeenSet = false;

    Aws::String m_subscribedAt;
    bool m_subscribedAtHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
