﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplifyuibuilder/AmplifyUIBuilder_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AmplifyUIBuilder {
namespace Model {

/**
 * <p>Stores the metadata information about a feature on a form.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/PutMetadataFlagBody">AWS
 * API Reference</a></p>
 */
class PutMetadataFlagBody {
 public:
  AWS_AMPLIFYUIBUILDER_API PutMetadataFlagBody() = default;
  AWS_AMPLIFYUIBUILDER_API PutMetadataFlagBody(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API PutMetadataFlagBody& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The new information to store.</p>
   */
  inline const Aws::String& GetNewValue() const { return m_newValue; }
  inline bool NewValueHasBeenSet() const { return m_newValueHasBeenSet; }
  template <typename NewValueT = Aws::String>
  void SetNewValue(NewValueT&& value) {
    m_newValueHasBeenSet = true;
    m_newValue = std::forward<NewValueT>(value);
  }
  template <typename NewValueT = Aws::String>
  PutMetadataFlagBody& WithNewValue(NewValueT&& value) {
    SetNewValue(std::forward<NewValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_newValue;
  bool m_newValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace AmplifyUIBuilder
}  // namespace Aws
