﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudTrail {
namespace Model {
/**
 * <p>Returns the objects or data listed below if successful. Otherwise, returns an
 * error.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrailResponse">AWS
 * API Reference</a></p>
 */
class UpdateTrailResult {
 public:
  AWS_CLOUDTRAIL_API UpdateTrailResult() = default;
  AWS_CLOUDTRAIL_API UpdateTrailResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDTRAIL_API UpdateTrailResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Specifies the name of the trail.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateTrailResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the name of the Amazon S3 bucket designated for publishing log
   * files.</p>
   */
  inline const Aws::String& GetS3BucketName() const { return m_s3BucketName; }
  template <typename S3BucketNameT = Aws::String>
  void SetS3BucketName(S3BucketNameT&& value) {
    m_s3BucketNameHasBeenSet = true;
    m_s3BucketName = std::forward<S3BucketNameT>(value);
  }
  template <typename S3BucketNameT = Aws::String>
  UpdateTrailResult& WithS3BucketName(S3BucketNameT&& value) {
    SetS3BucketName(std::forward<S3BucketNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the Amazon S3 key prefix that comes after the name of the bucket
   * you have designated for log file delivery. For more information, see <a
   * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding
   * Your IAM Log Files</a>.</p>
   */
  inline const Aws::String& GetS3KeyPrefix() const { return m_s3KeyPrefix; }
  template <typename S3KeyPrefixT = Aws::String>
  void SetS3KeyPrefix(S3KeyPrefixT&& value) {
    m_s3KeyPrefixHasBeenSet = true;
    m_s3KeyPrefix = std::forward<S3KeyPrefixT>(value);
  }
  template <typename S3KeyPrefixT = Aws::String>
  UpdateTrailResult& WithS3KeyPrefix(S3KeyPrefixT&& value) {
    SetS3KeyPrefix(std::forward<S3KeyPrefixT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send
   * notifications when log files are delivered. The following is the format of a
   * topic ARN.</p> <p> <code>arn:aws:sns:us-east-2:123456789012:MyTopic</code> </p>
   */
  inline const Aws::String& GetSnsTopicARN() const { return m_snsTopicARN; }
  template <typename SnsTopicARNT = Aws::String>
  void SetSnsTopicARN(SnsTopicARNT&& value) {
    m_snsTopicARNHasBeenSet = true;
    m_snsTopicARN = std::forward<SnsTopicARNT>(value);
  }
  template <typename SnsTopicARNT = Aws::String>
  UpdateTrailResult& WithSnsTopicARN(SnsTopicARNT&& value) {
    SetSnsTopicARN(std::forward<SnsTopicARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the trail is publishing events from global services such as
   * IAM to the log files.</p>
   */
  inline bool GetIncludeGlobalServiceEvents() const { return m_includeGlobalServiceEvents; }
  inline void SetIncludeGlobalServiceEvents(bool value) {
    m_includeGlobalServiceEventsHasBeenSet = true;
    m_includeGlobalServiceEvents = value;
  }
  inline UpdateTrailResult& WithIncludeGlobalServiceEvents(bool value) {
    SetIncludeGlobalServiceEvents(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the trail exists in one Region or in all Regions.</p>
   */
  inline bool GetIsMultiRegionTrail() const { return m_isMultiRegionTrail; }
  inline void SetIsMultiRegionTrail(bool value) {
    m_isMultiRegionTrailHasBeenSet = true;
    m_isMultiRegionTrail = value;
  }
  inline UpdateTrailResult& WithIsMultiRegionTrail(bool value) {
    SetIsMultiRegionTrail(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the ARN of the trail that was updated. The following is the format
   * of a trail ARN.</p> <p>
   * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code> </p>
   */
  inline const Aws::String& GetTrailARN() const { return m_trailARN; }
  template <typename TrailARNT = Aws::String>
  void SetTrailARN(TrailARNT&& value) {
    m_trailARNHasBeenSet = true;
    m_trailARN = std::forward<TrailARNT>(value);
  }
  template <typename TrailARNT = Aws::String>
  UpdateTrailResult& WithTrailARN(TrailARNT&& value) {
    SetTrailARN(std::forward<TrailARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether log file integrity validation is enabled.</p>
   */
  inline bool GetLogFileValidationEnabled() const { return m_logFileValidationEnabled; }
  inline void SetLogFileValidationEnabled(bool value) {
    m_logFileValidationEnabledHasBeenSet = true;
    m_logFileValidationEnabled = value;
  }
  inline UpdateTrailResult& WithLogFileValidationEnabled(bool value) {
    SetLogFileValidationEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
   * logs are delivered.</p>
   */
  inline const Aws::String& GetCloudWatchLogsLogGroupArn() const { return m_cloudWatchLogsLogGroupArn; }
  template <typename CloudWatchLogsLogGroupArnT = Aws::String>
  void SetCloudWatchLogsLogGroupArn(CloudWatchLogsLogGroupArnT&& value) {
    m_cloudWatchLogsLogGroupArnHasBeenSet = true;
    m_cloudWatchLogsLogGroupArn = std::forward<CloudWatchLogsLogGroupArnT>(value);
  }
  template <typename CloudWatchLogsLogGroupArnT = Aws::String>
  UpdateTrailResult& WithCloudWatchLogsLogGroupArn(CloudWatchLogsLogGroupArnT&& value) {
    SetCloudWatchLogsLogGroupArn(std::forward<CloudWatchLogsLogGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the role for the CloudWatch Logs endpoint to assume to write to a
   * user's log group.</p>
   */
  inline const Aws::String& GetCloudWatchLogsRoleArn() const { return m_cloudWatchLogsRoleArn; }
  template <typename CloudWatchLogsRoleArnT = Aws::String>
  void SetCloudWatchLogsRoleArn(CloudWatchLogsRoleArnT&& value) {
    m_cloudWatchLogsRoleArnHasBeenSet = true;
    m_cloudWatchLogsRoleArn = std::forward<CloudWatchLogsRoleArnT>(value);
  }
  template <typename CloudWatchLogsRoleArnT = Aws::String>
  UpdateTrailResult& WithCloudWatchLogsRoleArn(CloudWatchLogsRoleArnT&& value) {
    SetCloudWatchLogsRoleArn(std::forward<CloudWatchLogsRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the KMS key ID that encrypts the logs and digest files delivered by
   * CloudTrail. The value is a fully specified ARN to a KMS key in the following
   * format.</p> <p>
   * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
   * </p>
   */
  inline const Aws::String& GetKmsKeyId() const { return m_kmsKeyId; }
  template <typename KmsKeyIdT = Aws::String>
  void SetKmsKeyId(KmsKeyIdT&& value) {
    m_kmsKeyIdHasBeenSet = true;
    m_kmsKeyId = std::forward<KmsKeyIdT>(value);
  }
  template <typename KmsKeyIdT = Aws::String>
  UpdateTrailResult& WithKmsKeyId(KmsKeyIdT&& value) {
    SetKmsKeyId(std::forward<KmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the trail is an organization trail.</p>
   */
  inline bool GetIsOrganizationTrail() const { return m_isOrganizationTrail; }
  inline void SetIsOrganizationTrail(bool value) {
    m_isOrganizationTrailHasBeenSet = true;
    m_isOrganizationTrail = value;
  }
  inline UpdateTrailResult& WithIsOrganizationTrail(bool value) {
    SetIsOrganizationTrail(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateTrailResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_s3BucketName;
  bool m_s3BucketNameHasBeenSet = false;

  Aws::String m_s3KeyPrefix;
  bool m_s3KeyPrefixHasBeenSet = false;

  Aws::String m_snsTopicARN;
  bool m_snsTopicARNHasBeenSet = false;

  bool m_includeGlobalServiceEvents{false};
  bool m_includeGlobalServiceEventsHasBeenSet = false;

  bool m_isMultiRegionTrail{false};
  bool m_isMultiRegionTrailHasBeenSet = false;

  Aws::String m_trailARN;
  bool m_trailARNHasBeenSet = false;

  bool m_logFileValidationEnabled{false};
  bool m_logFileValidationEnabledHasBeenSet = false;

  Aws::String m_cloudWatchLogsLogGroupArn;
  bool m_cloudWatchLogsLogGroupArnHasBeenSet = false;

  Aws::String m_cloudWatchLogsRoleArn;
  bool m_cloudWatchLogsRoleArnHasBeenSet = false;

  Aws::String m_kmsKeyId;
  bool m_kmsKeyIdHasBeenSet = false;

  bool m_isOrganizationTrail{false};
  bool m_isOrganizationTrailHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
