﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/ConnectRequest.h>
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Connect {
namespace Model {

/**
 */
class CreateViewVersionRequest : public ConnectRequest {
 public:
  AWS_CONNECT_API CreateViewVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateViewVersion"; }

  AWS_CONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the Amazon Connect instance. You can find the instanceId in
   * the ARN of the instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  CreateViewVersionRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code>
   * can be used.</p>
   */
  inline const Aws::String& GetViewId() const { return m_viewId; }
  inline bool ViewIdHasBeenSet() const { return m_viewIdHasBeenSet; }
  template <typename ViewIdT = Aws::String>
  void SetViewId(ViewIdT&& value) {
    m_viewIdHasBeenSet = true;
    m_viewId = std::forward<ViewIdT>(value);
  }
  template <typename ViewIdT = Aws::String>
  CreateViewVersionRequest& WithViewId(ViewIdT&& value) {
    SetViewId(std::forward<ViewIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description for the version being published.</p>
   */
  inline const Aws::String& GetVersionDescription() const { return m_versionDescription; }
  inline bool VersionDescriptionHasBeenSet() const { return m_versionDescriptionHasBeenSet; }
  template <typename VersionDescriptionT = Aws::String>
  void SetVersionDescription(VersionDescriptionT&& value) {
    m_versionDescriptionHasBeenSet = true;
    m_versionDescription = std::forward<VersionDescriptionT>(value);
  }
  template <typename VersionDescriptionT = Aws::String>
  CreateViewVersionRequest& WithVersionDescription(VersionDescriptionT&& value) {
    SetVersionDescription(std::forward<VersionDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the checksum value of the latest published view content.</p>
   */
  inline const Aws::String& GetViewContentSha256() const { return m_viewContentSha256; }
  inline bool ViewContentSha256HasBeenSet() const { return m_viewContentSha256HasBeenSet; }
  template <typename ViewContentSha256T = Aws::String>
  void SetViewContentSha256(ViewContentSha256T&& value) {
    m_viewContentSha256HasBeenSet = true;
    m_viewContentSha256 = std::forward<ViewContentSha256T>(value);
  }
  template <typename ViewContentSha256T = Aws::String>
  CreateViewVersionRequest& WithViewContentSha256(ViewContentSha256T&& value) {
    SetViewContentSha256(std::forward<ViewContentSha256T>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;
  bool m_instanceIdHasBeenSet = false;

  Aws::String m_viewId;
  bool m_viewIdHasBeenSet = false;

  Aws::String m_versionDescription;
  bool m_versionDescriptionHasBeenSet = false;

  Aws::String m_viewContentSha256;
  bool m_viewContentSha256HasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
