﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/deadline/Deadline_EXPORTS.h>
#include <aws/deadline/model/QueueLimitAssociationStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace deadline {
namespace Model {

/**
 * <p>Provides information about the association between a queue and a
 * limit.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/QueueLimitAssociationSummary">AWS
 * API Reference</a></p>
 */
class QueueLimitAssociationSummary {
 public:
  AWS_DEADLINE_API QueueLimitAssociationSummary() = default;
  AWS_DEADLINE_API QueueLimitAssociationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API QueueLimitAssociationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEADLINE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Unix timestamp of the date and time that the association was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  QueueLimitAssociationSummary& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user identifier of the person that created the association.</p>
   */
  inline const Aws::String& GetCreatedBy() const { return m_createdBy; }
  inline bool CreatedByHasBeenSet() const { return m_createdByHasBeenSet; }
  template <typename CreatedByT = Aws::String>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = Aws::String>
  QueueLimitAssociationSummary& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Unix timestamp of the date and time that the association was last
   * updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  QueueLimitAssociationSummary& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user identifier of the person that updated the association.</p>
   */
  inline const Aws::String& GetUpdatedBy() const { return m_updatedBy; }
  inline bool UpdatedByHasBeenSet() const { return m_updatedByHasBeenSet; }
  template <typename UpdatedByT = Aws::String>
  void SetUpdatedBy(UpdatedByT&& value) {
    m_updatedByHasBeenSet = true;
    m_updatedBy = std::forward<UpdatedByT>(value);
  }
  template <typename UpdatedByT = Aws::String>
  QueueLimitAssociationSummary& WithUpdatedBy(UpdatedByT&& value) {
    SetUpdatedBy(std::forward<UpdatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the queue in the association.</p>
   */
  inline const Aws::String& GetQueueId() const { return m_queueId; }
  inline bool QueueIdHasBeenSet() const { return m_queueIdHasBeenSet; }
  template <typename QueueIdT = Aws::String>
  void SetQueueId(QueueIdT&& value) {
    m_queueIdHasBeenSet = true;
    m_queueId = std::forward<QueueIdT>(value);
  }
  template <typename QueueIdT = Aws::String>
  QueueLimitAssociationSummary& WithQueueId(QueueIdT&& value) {
    SetQueueId(std::forward<QueueIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the limit in the association.</p>
   */
  inline const Aws::String& GetLimitId() const { return m_limitId; }
  inline bool LimitIdHasBeenSet() const { return m_limitIdHasBeenSet; }
  template <typename LimitIdT = Aws::String>
  void SetLimitId(LimitIdT&& value) {
    m_limitIdHasBeenSet = true;
    m_limitId = std::forward<LimitIdT>(value);
  }
  template <typename LimitIdT = Aws::String>
  QueueLimitAssociationSummary& WithLimitId(LimitIdT&& value) {
    SetLimitId(std::forward<LimitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of task scheduling in the queue-limit association.</p> <ul> <li>
   * <p> <code>ACTIVE</code> - Association is active.</p> </li> <li> <p>
   * <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped
   * scheduling new tasks and is completing current tasks.</p> </li> <li> <p>
   * <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped
   * scheduling new tasks and is canceling current tasks.</p> </li> <li> <p>
   * <code>STOPPED</code> - Association has been stopped.</p> </li> </ul>
   */
  inline QueueLimitAssociationStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(QueueLimitAssociationStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline QueueLimitAssociationSummary& WithStatus(QueueLimitAssociationStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;

  Aws::String m_createdBy;
  bool m_createdByHasBeenSet = false;

  Aws::Utils::DateTime m_updatedAt{};
  bool m_updatedAtHasBeenSet = false;

  Aws::String m_updatedBy;
  bool m_updatedByHasBeenSet = false;

  Aws::String m_queueId;
  bool m_queueIdHasBeenSet = false;

  Aws::String m_limitId;
  bool m_limitIdHasBeenSet = false;

  QueueLimitAssociationStatus m_status{QueueLimitAssociationStatus::NOT_SET};
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace deadline
}  // namespace Aws
