﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/devicefarm/DeviceFarmRequest.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/TestGridSessionArtifactCategory.h>

#include <utility>

namespace Aws {
namespace DeviceFarm {
namespace Model {

/**
 */
class ListTestGridSessionArtifactsRequest : public DeviceFarmRequest {
 public:
  AWS_DEVICEFARM_API ListTestGridSessionArtifactsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListTestGridSessionArtifacts"; }

  AWS_DEVICEFARM_API Aws::String SerializePayload() const override;

  AWS_DEVICEFARM_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ARN of a <a>TestGridSession</a>. </p>
   */
  inline const Aws::String& GetSessionArn() const { return m_sessionArn; }
  inline bool SessionArnHasBeenSet() const { return m_sessionArnHasBeenSet; }
  template <typename SessionArnT = Aws::String>
  void SetSessionArn(SessionArnT&& value) {
    m_sessionArnHasBeenSet = true;
    m_sessionArn = std::forward<SessionArnT>(value);
  }
  template <typename SessionArnT = Aws::String>
  ListTestGridSessionArtifactsRequest& WithSessionArn(SessionArnT&& value) {
    SetSessionArn(std::forward<SessionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Limit results to a specified type of artifact.</p>
   */
  inline TestGridSessionArtifactCategory GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(TestGridSessionArtifactCategory value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline ListTestGridSessionArtifactsRequest& WithType(TestGridSessionArtifactCategory value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to be returned by a request.</p>
   */
  inline int GetMaxResult() const { return m_maxResult; }
  inline bool MaxResultHasBeenSet() const { return m_maxResultHasBeenSet; }
  inline void SetMaxResult(int value) {
    m_maxResultHasBeenSet = true;
    m_maxResult = value;
  }
  inline ListTestGridSessionArtifactsRequest& WithMaxResult(int value) {
    SetMaxResult(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Pagination token.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTestGridSessionArtifactsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sessionArn;
  bool m_sessionArnHasBeenSet = false;

  TestGridSessionArtifactCategory m_type{TestGridSessionArtifactCategory::NOT_SET};
  bool m_typeHasBeenSet = false;

  int m_maxResult{0};
  bool m_maxResultHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
