﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/eks-auth/EKSAuth_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EKSAuth {
namespace Model {

/**
 * <p>An object with the permanent IAM role identity and the temporary session
 * name.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumedRoleUser">AWS
 * API Reference</a></p>
 */
class AssumedRoleUser {
 public:
  AWS_EKSAUTH_API AssumedRoleUser() = default;
  AWS_EKSAUTH_API AssumedRoleUser(Aws::Utils::Json::JsonView jsonValue);
  AWS_EKSAUTH_API AssumedRoleUser& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EKSAUTH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the IAM role that the temporary credentials authenticate to.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  AssumedRoleUser& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The session name of the temporary session requested to STS. The value is a
   * unique identifier that contains the role ID, a colon (<code>:</code>), and the
   * role session name of the role that is being assumed. The role ID is generated by
   * IAM when the role is created. The role session name part of the value follows
   * this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i>
   * </code> </p>
   */
  inline const Aws::String& GetAssumeRoleId() const { return m_assumeRoleId; }
  inline bool AssumeRoleIdHasBeenSet() const { return m_assumeRoleIdHasBeenSet; }
  template <typename AssumeRoleIdT = Aws::String>
  void SetAssumeRoleId(AssumeRoleIdT&& value) {
    m_assumeRoleIdHasBeenSet = true;
    m_assumeRoleId = std::forward<AssumeRoleIdT>(value);
  }
  template <typename AssumeRoleIdT = Aws::String>
  AssumedRoleUser& WithAssumeRoleId(AssumeRoleIdT&& value) {
    SetAssumeRoleId(std::forward<AssumeRoleIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_assumeRoleId;
  bool m_assumeRoleIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EKSAuth
}  // namespace Aws
