﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {
class StartNotebookExecutionResult {
 public:
  AWS_EMR_API StartNotebookExecutionResult() = default;
  AWS_EMR_API StartNotebookExecutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EMR_API StartNotebookExecutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier of the notebook execution.</p>
   */
  inline const Aws::String& GetNotebookExecutionId() const { return m_notebookExecutionId; }
  template <typename NotebookExecutionIdT = Aws::String>
  void SetNotebookExecutionId(NotebookExecutionIdT&& value) {
    m_notebookExecutionIdHasBeenSet = true;
    m_notebookExecutionId = std::forward<NotebookExecutionIdT>(value);
  }
  template <typename NotebookExecutionIdT = Aws::String>
  StartNotebookExecutionResult& WithNotebookExecutionId(NotebookExecutionIdT&& value) {
    SetNotebookExecutionId(std::forward<NotebookExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartNotebookExecutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_notebookExecutionId;
  bool m_notebookExecutionIdHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
