﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/fis/FIS_EXPORTS.h>
#include <aws/fis/model/ExperimentCloudWatchLogsLogConfiguration.h>
#include <aws/fis/model/ExperimentS3LogConfiguration.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FIS {
namespace Model {

/**
 * <p>Describes the configuration for experiment logging.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ExperimentLogConfiguration">AWS
 * API Reference</a></p>
 */
class ExperimentLogConfiguration {
 public:
  AWS_FIS_API ExperimentLogConfiguration() = default;
  AWS_FIS_API ExperimentLogConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API ExperimentLogConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The configuration for experiment logging to Amazon CloudWatch Logs.</p>
   */
  inline const ExperimentCloudWatchLogsLogConfiguration& GetCloudWatchLogsConfiguration() const { return m_cloudWatchLogsConfiguration; }
  inline bool CloudWatchLogsConfigurationHasBeenSet() const { return m_cloudWatchLogsConfigurationHasBeenSet; }
  template <typename CloudWatchLogsConfigurationT = ExperimentCloudWatchLogsLogConfiguration>
  void SetCloudWatchLogsConfiguration(CloudWatchLogsConfigurationT&& value) {
    m_cloudWatchLogsConfigurationHasBeenSet = true;
    m_cloudWatchLogsConfiguration = std::forward<CloudWatchLogsConfigurationT>(value);
  }
  template <typename CloudWatchLogsConfigurationT = ExperimentCloudWatchLogsLogConfiguration>
  ExperimentLogConfiguration& WithCloudWatchLogsConfiguration(CloudWatchLogsConfigurationT&& value) {
    SetCloudWatchLogsConfiguration(std::forward<CloudWatchLogsConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration for experiment logging to Amazon S3.</p>
   */
  inline const ExperimentS3LogConfiguration& GetS3Configuration() const { return m_s3Configuration; }
  inline bool S3ConfigurationHasBeenSet() const { return m_s3ConfigurationHasBeenSet; }
  template <typename S3ConfigurationT = ExperimentS3LogConfiguration>
  void SetS3Configuration(S3ConfigurationT&& value) {
    m_s3ConfigurationHasBeenSet = true;
    m_s3Configuration = std::forward<S3ConfigurationT>(value);
  }
  template <typename S3ConfigurationT = ExperimentS3LogConfiguration>
  ExperimentLogConfiguration& WithS3Configuration(S3ConfigurationT&& value) {
    SetS3Configuration(std::forward<S3ConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The schema version.</p>
   */
  inline int GetLogSchemaVersion() const { return m_logSchemaVersion; }
  inline bool LogSchemaVersionHasBeenSet() const { return m_logSchemaVersionHasBeenSet; }
  inline void SetLogSchemaVersion(int value) {
    m_logSchemaVersionHasBeenSet = true;
    m_logSchemaVersion = value;
  }
  inline ExperimentLogConfiguration& WithLogSchemaVersion(int value) {
    SetLogSchemaVersion(value);
    return *this;
  }
  ///@}
 private:
  ExperimentCloudWatchLogsLogConfiguration m_cloudWatchLogsConfiguration;
  bool m_cloudWatchLogsConfigurationHasBeenSet = false;

  ExperimentS3LogConfiguration m_s3Configuration;
  bool m_s3ConfigurationHasBeenSet = false;

  int m_logSchemaVersion{0};
  bool m_logSchemaVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
