﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glue/GlueRequest.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Glue {
namespace Model {

/**
 */
class DeleteSessionRequest : public GlueRequest {
 public:
  AWS_GLUE_API DeleteSessionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteSession"; }

  AWS_GLUE_API Aws::String SerializePayload() const override;

  AWS_GLUE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The ID of the session to be deleted.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  DeleteSessionRequest& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the origin of the delete session request.</p>
   */
  inline const Aws::String& GetRequestOrigin() const { return m_requestOrigin; }
  inline bool RequestOriginHasBeenSet() const { return m_requestOriginHasBeenSet; }
  template <typename RequestOriginT = Aws::String>
  void SetRequestOrigin(RequestOriginT&& value) {
    m_requestOriginHasBeenSet = true;
    m_requestOrigin = std::forward<RequestOriginT>(value);
  }
  template <typename RequestOriginT = Aws::String>
  DeleteSessionRequest& WithRequestOrigin(RequestOriginT&& value) {
    SetRequestOrigin(std::forward<RequestOriginT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_requestOrigin;
  bool m_requestOriginHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
