﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>
#include <aws/greengrass/model/DeploymentType.h>
#include <aws/greengrass/model/ErrorDetail.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Greengrass {
namespace Model {

/**
 * Information about an individual group deployment in a bulk deployment
 * operation.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/BulkDeploymentResult">AWS
 * API Reference</a></p>
 */
class BulkDeploymentResult {
 public:
  AWS_GREENGRASS_API BulkDeploymentResult() = default;
  AWS_GREENGRASS_API BulkDeploymentResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_GREENGRASS_API BulkDeploymentResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GREENGRASS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * The time, in ISO format, when the deployment was created.
   */
  inline const Aws::String& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::String>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::String>
  BulkDeploymentResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ARN of the group deployment.
   */
  inline const Aws::String& GetDeploymentArn() const { return m_deploymentArn; }
  inline bool DeploymentArnHasBeenSet() const { return m_deploymentArnHasBeenSet; }
  template <typename DeploymentArnT = Aws::String>
  void SetDeploymentArn(DeploymentArnT&& value) {
    m_deploymentArnHasBeenSet = true;
    m_deploymentArn = std::forward<DeploymentArnT>(value);
  }
  template <typename DeploymentArnT = Aws::String>
  BulkDeploymentResult& WithDeploymentArn(DeploymentArnT&& value) {
    SetDeploymentArn(std::forward<DeploymentArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ID of the group deployment.
   */
  inline const Aws::String& GetDeploymentId() const { return m_deploymentId; }
  inline bool DeploymentIdHasBeenSet() const { return m_deploymentIdHasBeenSet; }
  template <typename DeploymentIdT = Aws::String>
  void SetDeploymentId(DeploymentIdT&& value) {
    m_deploymentIdHasBeenSet = true;
    m_deploymentId = std::forward<DeploymentIdT>(value);
  }
  template <typename DeploymentIdT = Aws::String>
  BulkDeploymentResult& WithDeploymentId(DeploymentIdT&& value) {
    SetDeploymentId(std::forward<DeploymentIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The current status of the group deployment: ''InProgress'', ''Building'',
   * ''Success'', or ''Failure''.
   */
  inline const Aws::String& GetDeploymentStatus() const { return m_deploymentStatus; }
  inline bool DeploymentStatusHasBeenSet() const { return m_deploymentStatusHasBeenSet; }
  template <typename DeploymentStatusT = Aws::String>
  void SetDeploymentStatus(DeploymentStatusT&& value) {
    m_deploymentStatusHasBeenSet = true;
    m_deploymentStatus = std::forward<DeploymentStatusT>(value);
  }
  template <typename DeploymentStatusT = Aws::String>
  BulkDeploymentResult& WithDeploymentStatus(DeploymentStatusT&& value) {
    SetDeploymentStatus(std::forward<DeploymentStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The type of the deployment.
   */
  inline DeploymentType GetDeploymentType() const { return m_deploymentType; }
  inline bool DeploymentTypeHasBeenSet() const { return m_deploymentTypeHasBeenSet; }
  inline void SetDeploymentType(DeploymentType value) {
    m_deploymentTypeHasBeenSet = true;
    m_deploymentType = value;
  }
  inline BulkDeploymentResult& WithDeploymentType(DeploymentType value) {
    SetDeploymentType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * Details about the error.
   */
  inline const Aws::Vector<ErrorDetail>& GetErrorDetails() const { return m_errorDetails; }
  inline bool ErrorDetailsHasBeenSet() const { return m_errorDetailsHasBeenSet; }
  template <typename ErrorDetailsT = Aws::Vector<ErrorDetail>>
  void SetErrorDetails(ErrorDetailsT&& value) {
    m_errorDetailsHasBeenSet = true;
    m_errorDetails = std::forward<ErrorDetailsT>(value);
  }
  template <typename ErrorDetailsT = Aws::Vector<ErrorDetail>>
  BulkDeploymentResult& WithErrorDetails(ErrorDetailsT&& value) {
    SetErrorDetails(std::forward<ErrorDetailsT>(value));
    return *this;
  }
  template <typename ErrorDetailsT = ErrorDetail>
  BulkDeploymentResult& AddErrorDetails(ErrorDetailsT&& value) {
    m_errorDetailsHasBeenSet = true;
    m_errorDetails.emplace_back(std::forward<ErrorDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The error message for a failed deployment
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BulkDeploymentResult& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ARN of the Greengrass group.
   */
  inline const Aws::String& GetGroupArn() const { return m_groupArn; }
  inline bool GroupArnHasBeenSet() const { return m_groupArnHasBeenSet; }
  template <typename GroupArnT = Aws::String>
  void SetGroupArn(GroupArnT&& value) {
    m_groupArnHasBeenSet = true;
    m_groupArn = std::forward<GroupArnT>(value);
  }
  template <typename GroupArnT = Aws::String>
  BulkDeploymentResult& WithGroupArn(GroupArnT&& value) {
    SetGroupArn(std::forward<GroupArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_createdAt;
  bool m_createdAtHasBeenSet = false;

  Aws::String m_deploymentArn;
  bool m_deploymentArnHasBeenSet = false;

  Aws::String m_deploymentId;
  bool m_deploymentIdHasBeenSet = false;

  Aws::String m_deploymentStatus;
  bool m_deploymentStatusHasBeenSet = false;

  DeploymentType m_deploymentType{DeploymentType::NOT_SET};
  bool m_deploymentTypeHasBeenSet = false;

  Aws::Vector<ErrorDetail> m_errorDetails;
  bool m_errorDetailsHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;

  Aws::String m_groupArn;
  bool m_groupArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
