﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/FilterCondition.h>
#include <aws/guardduty/model/ListMalwareScansCriterionKey.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Represents a condition that when matched will be added to the response of the
 * operation. Irrespective of using any filter criteria, an administrator account
 * can view the scan entries for all of its member accounts. However, each member
 * account can view the scan entries only for their own account.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMalwareScansFilterCriterion">AWS
 * API Reference</a></p>
 */
class ListMalwareScansFilterCriterion {
 public:
  AWS_GUARDDUTY_API ListMalwareScansFilterCriterion() = default;
  AWS_GUARDDUTY_API ListMalwareScansFilterCriterion(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API ListMalwareScansFilterCriterion& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An enum value representing possible scan properties to match with given scan
   * entries.</p>
   */
  inline ListMalwareScansCriterionKey GetListMalwareScansCriterionKey() const { return m_listMalwareScansCriterionKey; }
  inline bool ListMalwareScansCriterionKeyHasBeenSet() const { return m_listMalwareScansCriterionKeyHasBeenSet; }
  inline void SetListMalwareScansCriterionKey(ListMalwareScansCriterionKey value) {
    m_listMalwareScansCriterionKeyHasBeenSet = true;
    m_listMalwareScansCriterionKey = value;
  }
  inline ListMalwareScansFilterCriterion& WithListMalwareScansCriterionKey(ListMalwareScansCriterionKey value) {
    SetListMalwareScansCriterionKey(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains information about the condition.</p>
   */
  inline const FilterCondition& GetFilterCondition() const { return m_filterCondition; }
  inline bool FilterConditionHasBeenSet() const { return m_filterConditionHasBeenSet; }
  template <typename FilterConditionT = FilterCondition>
  void SetFilterCondition(FilterConditionT&& value) {
    m_filterConditionHasBeenSet = true;
    m_filterCondition = std::forward<FilterConditionT>(value);
  }
  template <typename FilterConditionT = FilterCondition>
  ListMalwareScansFilterCriterion& WithFilterCondition(FilterConditionT&& value) {
    SetFilterCondition(std::forward<FilterConditionT>(value));
    return *this;
  }
  ///@}
 private:
  ListMalwareScansCriterionKey m_listMalwareScansCriterionKey{ListMalwareScansCriterionKey::NOT_SET};
  bool m_listMalwareScansCriterionKeyHasBeenSet = false;

  FilterCondition m_filterCondition;
  bool m_filterConditionHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
