﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/ScanEc2InstanceWithFindingsResult.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>An object that contains information on the status of all Malware Protection
 * data sources.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionConfigurationResult">AWS
 * API Reference</a></p>
 */
class MalwareProtectionConfigurationResult {
 public:
  AWS_GUARDDUTY_API MalwareProtectionConfigurationResult() = default;
  AWS_GUARDDUTY_API MalwareProtectionConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API MalwareProtectionConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Describes the configuration of Malware Protection for EC2 instances with
   * findings.</p>
   */
  inline const ScanEc2InstanceWithFindingsResult& GetScanEc2InstanceWithFindings() const { return m_scanEc2InstanceWithFindings; }
  inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }
  template <typename ScanEc2InstanceWithFindingsT = ScanEc2InstanceWithFindingsResult>
  void SetScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    m_scanEc2InstanceWithFindingsHasBeenSet = true;
    m_scanEc2InstanceWithFindings = std::forward<ScanEc2InstanceWithFindingsT>(value);
  }
  template <typename ScanEc2InstanceWithFindingsT = ScanEc2InstanceWithFindingsResult>
  MalwareProtectionConfigurationResult& WithScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    SetScanEc2InstanceWithFindings(std::forward<ScanEc2InstanceWithFindingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The GuardDuty Malware Protection service role.</p>
   */
  inline const Aws::String& GetServiceRole() const { return m_serviceRole; }
  inline bool ServiceRoleHasBeenSet() const { return m_serviceRoleHasBeenSet; }
  template <typename ServiceRoleT = Aws::String>
  void SetServiceRole(ServiceRoleT&& value) {
    m_serviceRoleHasBeenSet = true;
    m_serviceRole = std::forward<ServiceRoleT>(value);
  }
  template <typename ServiceRoleT = Aws::String>
  MalwareProtectionConfigurationResult& WithServiceRole(ServiceRoleT&& value) {
    SetServiceRole(std::forward<ServiceRoleT>(value));
    return *this;
  }
  ///@}
 private:
  ScanEc2InstanceWithFindingsResult m_scanEc2InstanceWithFindings;
  bool m_scanEc2InstanceWithFindingsHasBeenSet = false;

  Aws::String m_serviceRole;
  bool m_serviceRoleHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
