﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/identitystore/IdentityStore_EXPORTS.h>
#include <aws/identitystore/model/GroupMembership.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IdentityStore {
namespace Model {
class ListGroupMembershipsForMemberResult {
 public:
  AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult() = default;
  AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of <code>GroupMembership</code> objects in the group for a specified
   * member.</p>
   */
  inline const Aws::Vector<GroupMembership>& GetGroupMemberships() const { return m_groupMemberships; }
  template <typename GroupMembershipsT = Aws::Vector<GroupMembership>>
  void SetGroupMemberships(GroupMembershipsT&& value) {
    m_groupMembershipsHasBeenSet = true;
    m_groupMemberships = std::forward<GroupMembershipsT>(value);
  }
  template <typename GroupMembershipsT = Aws::Vector<GroupMembership>>
  ListGroupMembershipsForMemberResult& WithGroupMemberships(GroupMembershipsT&& value) {
    SetGroupMemberships(std::forward<GroupMembershipsT>(value));
    return *this;
  }
  template <typename GroupMembershipsT = GroupMembership>
  ListGroupMembershipsForMemberResult& AddGroupMemberships(GroupMembershipsT&& value) {
    m_groupMembershipsHasBeenSet = true;
    m_groupMemberships.emplace_back(std::forward<GroupMembershipsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token used for the <code>ListUsers</code>,
   * <code>ListGroups</code>, and <code> ListGroupMemberships</code> API operations.
   * This value is generated by the identity store service. It is returned in the API
   * response if the total results are more than the size of one page. This token is
   * also returned when it is used in the API request to search for the next page.
   * </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListGroupMembershipsForMemberResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListGroupMembershipsForMemberResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<GroupMembership> m_groupMemberships;
  bool m_groupMembershipsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IdentityStore
}  // namespace Aws
