﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class DeleteBillingGroupRequest : public IoTRequest {
 public:
  AWS_IOT_API DeleteBillingGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteBillingGroup"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the billing group.</p>
   */
  inline const Aws::String& GetBillingGroupName() const { return m_billingGroupName; }
  inline bool BillingGroupNameHasBeenSet() const { return m_billingGroupNameHasBeenSet; }
  template <typename BillingGroupNameT = Aws::String>
  void SetBillingGroupName(BillingGroupNameT&& value) {
    m_billingGroupNameHasBeenSet = true;
    m_billingGroupName = std::forward<BillingGroupNameT>(value);
  }
  template <typename BillingGroupNameT = Aws::String>
  DeleteBillingGroupRequest& WithBillingGroupName(BillingGroupNameT&& value) {
    SetBillingGroupName(std::forward<BillingGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The expected version of the billing group. If the version of the billing
   * group does not match the expected version specified in the request, the
   * <code>DeleteBillingGroup</code> request is rejected with a
   * <code>VersionConflictException</code>.</p>
   */
  inline long long GetExpectedVersion() const { return m_expectedVersion; }
  inline bool ExpectedVersionHasBeenSet() const { return m_expectedVersionHasBeenSet; }
  inline void SetExpectedVersion(long long value) {
    m_expectedVersionHasBeenSet = true;
    m_expectedVersion = value;
  }
  inline DeleteBillingGroupRequest& WithExpectedVersion(long long value) {
    SetExpectedVersion(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_billingGroupName;
  bool m_billingGroupNameHasBeenSet = false;

  long long m_expectedVersion{0};
  bool m_expectedVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
