﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTFleetWise {
namespace Model {

/**
 * <p>Information about a created vehicle.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/CreateVehicleResponseItem">AWS
 * API Reference</a></p>
 */
class CreateVehicleResponseItem {
 public:
  AWS_IOTFLEETWISE_API CreateVehicleResponseItem() = default;
  AWS_IOTFLEETWISE_API CreateVehicleResponseItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API CreateVehicleResponseItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique ID of the vehicle to create.</p>
   */
  inline const Aws::String& GetVehicleName() const { return m_vehicleName; }
  inline bool VehicleNameHasBeenSet() const { return m_vehicleNameHasBeenSet; }
  template <typename VehicleNameT = Aws::String>
  void SetVehicleName(VehicleNameT&& value) {
    m_vehicleNameHasBeenSet = true;
    m_vehicleName = std::forward<VehicleNameT>(value);
  }
  template <typename VehicleNameT = Aws::String>
  CreateVehicleResponseItem& WithVehicleName(VehicleNameT&& value) {
    SetVehicleName(std::forward<VehicleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the created vehicle.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  CreateVehicleResponseItem& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of a created or validated Amazon Web Services IoT thing.</p>
   */
  inline const Aws::String& GetThingArn() const { return m_thingArn; }
  inline bool ThingArnHasBeenSet() const { return m_thingArnHasBeenSet; }
  template <typename ThingArnT = Aws::String>
  void SetThingArn(ThingArnT&& value) {
    m_thingArnHasBeenSet = true;
    m_thingArn = std::forward<ThingArnT>(value);
  }
  template <typename ThingArnT = Aws::String>
  CreateVehicleResponseItem& WithThingArn(ThingArnT&& value) {
    SetThingArn(std::forward<ThingArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vehicleName;
  bool m_vehicleNameHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_thingArn;
  bool m_thingArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTFleetWise
}  // namespace Aws
