﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lakeformation/LakeFormationRequest.h>
#include <aws/lakeformation/LakeFormation_EXPORTS.h>

#include <utility>

namespace Aws {
namespace LakeFormation {
namespace Model {

/**
 */
class CreateLFTagRequest : public LakeFormationRequest {
 public:
  AWS_LAKEFORMATION_API CreateLFTagRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateLFTag"; }

  AWS_LAKEFORMATION_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier for the Data Catalog. By default, the account ID. The Data
   * Catalog is the persistent metadata store. It contains database definitions,
   * table definitions, and other control information to manage your Lake Formation
   * environment. </p>
   */
  inline const Aws::String& GetCatalogId() const { return m_catalogId; }
  inline bool CatalogIdHasBeenSet() const { return m_catalogIdHasBeenSet; }
  template <typename CatalogIdT = Aws::String>
  void SetCatalogId(CatalogIdT&& value) {
    m_catalogIdHasBeenSet = true;
    m_catalogId = std::forward<CatalogIdT>(value);
  }
  template <typename CatalogIdT = Aws::String>
  CreateLFTagRequest& WithCatalogId(CatalogIdT&& value) {
    SetCatalogId(std::forward<CatalogIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The key-name for the LF-tag.</p>
   */
  inline const Aws::String& GetTagKey() const { return m_tagKey; }
  inline bool TagKeyHasBeenSet() const { return m_tagKeyHasBeenSet; }
  template <typename TagKeyT = Aws::String>
  void SetTagKey(TagKeyT&& value) {
    m_tagKeyHasBeenSet = true;
    m_tagKey = std::forward<TagKeyT>(value);
  }
  template <typename TagKeyT = Aws::String>
  CreateLFTagRequest& WithTagKey(TagKeyT&& value) {
    SetTagKey(std::forward<TagKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of possible values an attribute can take.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTagValues() const { return m_tagValues; }
  inline bool TagValuesHasBeenSet() const { return m_tagValuesHasBeenSet; }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  void SetTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues = std::forward<TagValuesT>(value);
  }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  CreateLFTagRequest& WithTagValues(TagValuesT&& value) {
    SetTagValues(std::forward<TagValuesT>(value));
    return *this;
  }
  template <typename TagValuesT = Aws::String>
  CreateLFTagRequest& AddTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues.emplace_back(std::forward<TagValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_catalogId;
  bool m_catalogIdHasBeenSet = false;

  Aws::String m_tagKey;
  bool m_tagKeyHasBeenSet = false;

  Aws::Vector<Aws::String> m_tagValues;
  bool m_tagValuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace LakeFormation
}  // namespace Aws
