﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/Personalize_EXPORTS.h>
#include <aws/personalize/model/Solution.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Personalize {
namespace Model {
class DescribeSolutionResult {
 public:
  AWS_PERSONALIZE_API DescribeSolutionResult() = default;
  AWS_PERSONALIZE_API DescribeSolutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PERSONALIZE_API DescribeSolutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An object that describes the solution.</p>
   */
  inline const Solution& GetSolution() const { return m_solution; }
  template <typename SolutionT = Solution>
  void SetSolution(SolutionT&& value) {
    m_solutionHasBeenSet = true;
    m_solution = std::forward<SolutionT>(value);
  }
  template <typename SolutionT = Solution>
  DescribeSolutionResult& WithSolution(SolutionT&& value) {
    SetSolution(std::forward<SolutionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeSolutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Solution m_solution;
  bool m_solutionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
