﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/Visibility.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The selected field options for the pivot table field options.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/PivotTableFieldOption">AWS
 * API Reference</a></p>
 */
class PivotTableFieldOption {
 public:
  AWS_QUICKSIGHT_API PivotTableFieldOption() = default;
  AWS_QUICKSIGHT_API PivotTableFieldOption(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API PivotTableFieldOption& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The field ID of the pivot table field.</p>
   */
  inline const Aws::String& GetFieldId() const { return m_fieldId; }
  inline bool FieldIdHasBeenSet() const { return m_fieldIdHasBeenSet; }
  template <typename FieldIdT = Aws::String>
  void SetFieldId(FieldIdT&& value) {
    m_fieldIdHasBeenSet = true;
    m_fieldId = std::forward<FieldIdT>(value);
  }
  template <typename FieldIdT = Aws::String>
  PivotTableFieldOption& WithFieldId(FieldIdT&& value) {
    SetFieldId(std::forward<FieldIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom label of the pivot table field.</p>
   */
  inline const Aws::String& GetCustomLabel() const { return m_customLabel; }
  inline bool CustomLabelHasBeenSet() const { return m_customLabelHasBeenSet; }
  template <typename CustomLabelT = Aws::String>
  void SetCustomLabel(CustomLabelT&& value) {
    m_customLabelHasBeenSet = true;
    m_customLabel = std::forward<CustomLabelT>(value);
  }
  template <typename CustomLabelT = Aws::String>
  PivotTableFieldOption& WithCustomLabel(CustomLabelT&& value) {
    SetCustomLabel(std::forward<CustomLabelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The visibility of the pivot table field.</p>
   */
  inline Visibility GetVisibility() const { return m_visibility; }
  inline bool VisibilityHasBeenSet() const { return m_visibilityHasBeenSet; }
  inline void SetVisibility(Visibility value) {
    m_visibilityHasBeenSet = true;
    m_visibility = value;
  }
  inline PivotTableFieldOption& WithVisibility(Visibility value) {
    SetVisibility(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_fieldId;
  bool m_fieldIdHasBeenSet = false;

  Aws::String m_customLabel;
  bool m_customLabelHasBeenSet = false;

  Visibility m_visibility{Visibility::NOT_SET};
  bool m_visibilityHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
