﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/DimensionField.h>
#include <aws/quicksight/model/MeasureField.h>
#include <aws/quicksight/model/TopBottomComputationType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The top ranked and bottom ranked computation configuration.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TopBottomRankedComputation">AWS
 * API Reference</a></p>
 */
class TopBottomRankedComputation {
 public:
  AWS_QUICKSIGHT_API TopBottomRankedComputation() = default;
  AWS_QUICKSIGHT_API TopBottomRankedComputation(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API TopBottomRankedComputation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID for a computation.</p>
   */
  inline const Aws::String& GetComputationId() const { return m_computationId; }
  inline bool ComputationIdHasBeenSet() const { return m_computationIdHasBeenSet; }
  template <typename ComputationIdT = Aws::String>
  void SetComputationId(ComputationIdT&& value) {
    m_computationIdHasBeenSet = true;
    m_computationId = std::forward<ComputationIdT>(value);
  }
  template <typename ComputationIdT = Aws::String>
  TopBottomRankedComputation& WithComputationId(ComputationIdT&& value) {
    SetComputationId(std::forward<ComputationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of a computation.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  TopBottomRankedComputation& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The category field that is used in a computation.</p>
   */
  inline const DimensionField& GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  template <typename CategoryT = DimensionField>
  void SetCategory(CategoryT&& value) {
    m_categoryHasBeenSet = true;
    m_category = std::forward<CategoryT>(value);
  }
  template <typename CategoryT = DimensionField>
  TopBottomRankedComputation& WithCategory(CategoryT&& value) {
    SetCategory(std::forward<CategoryT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value field that is used in a computation.</p>
   */
  inline const MeasureField& GetValue() const { return m_value; }
  inline bool ValueHasBeenSet() const { return m_valueHasBeenSet; }
  template <typename ValueT = MeasureField>
  void SetValue(ValueT&& value) {
    m_valueHasBeenSet = true;
    m_value = std::forward<ValueT>(value);
  }
  template <typename ValueT = MeasureField>
  TopBottomRankedComputation& WithValue(ValueT&& value) {
    SetValue(std::forward<ValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The result size of a top and bottom ranked computation.</p>
   */
  inline int GetResultSize() const { return m_resultSize; }
  inline bool ResultSizeHasBeenSet() const { return m_resultSizeHasBeenSet; }
  inline void SetResultSize(int value) {
    m_resultSizeHasBeenSet = true;
    m_resultSize = value;
  }
  inline TopBottomRankedComputation& WithResultSize(int value) {
    SetResultSize(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The computation type. Choose one of the following options:</p> <ul> <li>
   * <p>TOP: A top ranked computation.</p> </li> <li> <p>BOTTOM: A bottom ranked
   * computation.</p> </li> </ul>
   */
  inline TopBottomComputationType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(TopBottomComputationType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline TopBottomRankedComputation& WithType(TopBottomComputationType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_computationId;
  bool m_computationIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  DimensionField m_category;
  bool m_categoryHasBeenSet = false;

  MeasureField m_value;
  bool m_valueHasBeenSet = false;

  int m_resultSize{0};
  bool m_resultSizeHasBeenSet = false;

  TopBottomComputationType m_type{TopBottomComputationType::NOT_SET};
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
