﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/schemas/Schemas_EXPORTS.h>
#include <aws/schemas/model/Type.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Schemas {
namespace Model {

class SearchSchemaVersionSummary {
 public:
  AWS_SCHEMAS_API SearchSchemaVersionSummary() = default;
  AWS_SCHEMAS_API SearchSchemaVersionSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_SCHEMAS_API SearchSchemaVersionSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SCHEMAS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date the schema version was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedDate() const { return m_createdDate; }
  inline bool CreatedDateHasBeenSet() const { return m_createdDateHasBeenSet; }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  void SetCreatedDate(CreatedDateT&& value) {
    m_createdDateHasBeenSet = true;
    m_createdDate = std::forward<CreatedDateT>(value);
  }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  SearchSchemaVersionSummary& WithCreatedDate(CreatedDateT&& value) {
    SetCreatedDate(std::forward<CreatedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version number of the schema</p>
   */
  inline const Aws::String& GetSchemaVersion() const { return m_schemaVersion; }
  inline bool SchemaVersionHasBeenSet() const { return m_schemaVersionHasBeenSet; }
  template <typename SchemaVersionT = Aws::String>
  void SetSchemaVersion(SchemaVersionT&& value) {
    m_schemaVersionHasBeenSet = true;
    m_schemaVersion = std::forward<SchemaVersionT>(value);
  }
  template <typename SchemaVersionT = Aws::String>
  SearchSchemaVersionSummary& WithSchemaVersion(SchemaVersionT&& value) {
    SetSchemaVersion(std::forward<SchemaVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of schema.</p>
   */
  inline Type GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(Type value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline SearchSchemaVersionSummary& WithType(Type value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdDate{};
  bool m_createdDateHasBeenSet = false;

  Aws::String m_schemaVersion;
  bool m_schemaVersionHasBeenSet = false;

  Type m_type{Type::NOT_SET};
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
