﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/SWF_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {

/**
 * <p>Provides the details of the <code>ActivityTaskCompleted</code>
 * event.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/ActivityTaskCompletedEventAttributes">AWS
 * API Reference</a></p>
 */
class ActivityTaskCompletedEventAttributes {
 public:
  AWS_SWF_API ActivityTaskCompletedEventAttributes() = default;
  AWS_SWF_API ActivityTaskCompletedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API ActivityTaskCompletedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The results of the activity task.</p>
   */
  inline const Aws::String& GetResult() const { return m_result; }
  inline bool ResultHasBeenSet() const { return m_resultHasBeenSet; }
  template <typename ResultT = Aws::String>
  void SetResult(ResultT&& value) {
    m_resultHasBeenSet = true;
    m_result = std::forward<ResultT>(value);
  }
  template <typename ResultT = Aws::String>
  ActivityTaskCompletedEventAttributes& WithResult(ResultT&& value) {
    SetResult(std::forward<ResultT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>ActivityTaskScheduled</code> event that was recorded when
   * this activity task was scheduled. This information can be useful for diagnosing
   * problems by tracing back the chain of events leading up to this event.</p>
   */
  inline long long GetScheduledEventId() const { return m_scheduledEventId; }
  inline bool ScheduledEventIdHasBeenSet() const { return m_scheduledEventIdHasBeenSet; }
  inline void SetScheduledEventId(long long value) {
    m_scheduledEventIdHasBeenSet = true;
    m_scheduledEventId = value;
  }
  inline ActivityTaskCompletedEventAttributes& WithScheduledEventId(long long value) {
    SetScheduledEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>ActivityTaskStarted</code> event recorded when this
   * activity task was started. This information can be useful for diagnosing
   * problems by tracing back the chain of events leading up to this event.</p>
   */
  inline long long GetStartedEventId() const { return m_startedEventId; }
  inline bool StartedEventIdHasBeenSet() const { return m_startedEventIdHasBeenSet; }
  inline void SetStartedEventId(long long value) {
    m_startedEventIdHasBeenSet = true;
    m_startedEventId = value;
  }
  inline ActivityTaskCompletedEventAttributes& WithStartedEventId(long long value) {
    SetStartedEventId(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_result;
  bool m_resultHasBeenSet = false;

  long long m_scheduledEventId{0};
  bool m_scheduledEventIdHasBeenSet = false;

  long long m_startedEventId{0};
  bool m_startedEventIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
