﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/transcribe/TranscribeService_EXPORTS.h>
#include <aws/transcribe/model/LanguageModel.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace TranscribeService {
namespace Model {
class ListLanguageModelsResult {
 public:
  AWS_TRANSCRIBESERVICE_API ListLanguageModelsResult() = default;
  AWS_TRANSCRIBESERVICE_API ListLanguageModelsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSCRIBESERVICE_API ListLanguageModelsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If <code>NextToken</code> is present in your response, it indicates that not
   * all results are displayed. To view the next set of results, copy the string
   * associated with the <code>NextToken</code> parameter in your results output,
   * then run your request again including <code>NextToken</code> with the value of
   * the copied string. Repeat as needed to view all your results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListLanguageModelsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Provides information about the custom language models that match the criteria
   * specified in your request.</p>
   */
  inline const Aws::Vector<LanguageModel>& GetModels() const { return m_models; }
  template <typename ModelsT = Aws::Vector<LanguageModel>>
  void SetModels(ModelsT&& value) {
    m_modelsHasBeenSet = true;
    m_models = std::forward<ModelsT>(value);
  }
  template <typename ModelsT = Aws::Vector<LanguageModel>>
  ListLanguageModelsResult& WithModels(ModelsT&& value) {
    SetModels(std::forward<ModelsT>(value));
    return *this;
  }
  template <typename ModelsT = LanguageModel>
  ListLanguageModelsResult& AddModels(ModelsT&& value) {
    m_modelsHasBeenSet = true;
    m_models.emplace_back(std::forward<ModelsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLanguageModelsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<LanguageModel> m_models;
  bool m_modelsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace TranscribeService
}  // namespace Aws
