﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/vpc-lattice/VPCLattice_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace VPCLattice {
namespace Model {

/**
 * <p>Describes a path match type. Each rule can include only one of the following
 * types of paths.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PathMatchType">AWS
 * API Reference</a></p>
 */
class PathMatchType {
 public:
  AWS_VPCLATTICE_API PathMatchType() = default;
  AWS_VPCLATTICE_API PathMatchType(Aws::Utils::Json::JsonView jsonValue);
  AWS_VPCLATTICE_API PathMatchType& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_VPCLATTICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An exact match of the path.</p>
   */
  inline const Aws::String& GetExact() const { return m_exact; }
  inline bool ExactHasBeenSet() const { return m_exactHasBeenSet; }
  template <typename ExactT = Aws::String>
  void SetExact(ExactT&& value) {
    m_exactHasBeenSet = true;
    m_exact = std::forward<ExactT>(value);
  }
  template <typename ExactT = Aws::String>
  PathMatchType& WithExact(ExactT&& value) {
    SetExact(std::forward<ExactT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A prefix match of the path.</p>
   */
  inline const Aws::String& GetPrefix() const { return m_prefix; }
  inline bool PrefixHasBeenSet() const { return m_prefixHasBeenSet; }
  template <typename PrefixT = Aws::String>
  void SetPrefix(PrefixT&& value) {
    m_prefixHasBeenSet = true;
    m_prefix = std::forward<PrefixT>(value);
  }
  template <typename PrefixT = Aws::String>
  PathMatchType& WithPrefix(PrefixT&& value) {
    SetPrefix(std::forward<PrefixT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exact;
  bool m_exactHasBeenSet = false;

  Aws::String m_prefix;
  bool m_prefixHasBeenSet = false;
};

}  // namespace Model
}  // namespace VPCLattice
}  // namespace Aws
