﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>
#include <aws/workspaces-web/model/IpRule.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {

/**
 * <p>The IP access settings resource that can be associated with a web portal.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/IpAccessSettings">AWS
 * API Reference</a></p>
 */
class IpAccessSettings {
 public:
  AWS_WORKSPACESWEB_API IpAccessSettings() = default;
  AWS_WORKSPACESWEB_API IpAccessSettings(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESWEB_API IpAccessSettings& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WORKSPACESWEB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the IP access settings resource.</p>
   */
  inline const Aws::String& GetIpAccessSettingsArn() const { return m_ipAccessSettingsArn; }
  inline bool IpAccessSettingsArnHasBeenSet() const { return m_ipAccessSettingsArnHasBeenSet; }
  template <typename IpAccessSettingsArnT = Aws::String>
  void SetIpAccessSettingsArn(IpAccessSettingsArnT&& value) {
    m_ipAccessSettingsArnHasBeenSet = true;
    m_ipAccessSettingsArn = std::forward<IpAccessSettingsArnT>(value);
  }
  template <typename IpAccessSettingsArnT = Aws::String>
  IpAccessSettings& WithIpAccessSettingsArn(IpAccessSettingsArnT&& value) {
    SetIpAccessSettingsArn(std::forward<IpAccessSettingsArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of web portal ARNs that this IP access settings resource is associated
   * with.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAssociatedPortalArns() const { return m_associatedPortalArns; }
  inline bool AssociatedPortalArnsHasBeenSet() const { return m_associatedPortalArnsHasBeenSet; }
  template <typename AssociatedPortalArnsT = Aws::Vector<Aws::String>>
  void SetAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    m_associatedPortalArnsHasBeenSet = true;
    m_associatedPortalArns = std::forward<AssociatedPortalArnsT>(value);
  }
  template <typename AssociatedPortalArnsT = Aws::Vector<Aws::String>>
  IpAccessSettings& WithAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    SetAssociatedPortalArns(std::forward<AssociatedPortalArnsT>(value));
    return *this;
  }
  template <typename AssociatedPortalArnsT = Aws::String>
  IpAccessSettings& AddAssociatedPortalArns(AssociatedPortalArnsT&& value) {
    m_associatedPortalArnsHasBeenSet = true;
    m_associatedPortalArns.emplace_back(std::forward<AssociatedPortalArnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IP rules of the IP access settings.</p>
   */
  inline const Aws::Vector<IpRule>& GetIpRules() const { return m_ipRules; }
  inline bool IpRulesHasBeenSet() const { return m_ipRulesHasBeenSet; }
  template <typename IpRulesT = Aws::Vector<IpRule>>
  void SetIpRules(IpRulesT&& value) {
    m_ipRulesHasBeenSet = true;
    m_ipRules = std::forward<IpRulesT>(value);
  }
  template <typename IpRulesT = Aws::Vector<IpRule>>
  IpAccessSettings& WithIpRules(IpRulesT&& value) {
    SetIpRules(std::forward<IpRulesT>(value));
    return *this;
  }
  template <typename IpRulesT = IpRule>
  IpAccessSettings& AddIpRules(IpRulesT&& value) {
    m_ipRulesHasBeenSet = true;
    m_ipRules.emplace_back(std::forward<IpRulesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The display name of the IP access settings.</p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  IpAccessSettings& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the IP access settings.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  IpAccessSettings& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation date timestamp of the IP access settings.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDate() const { return m_creationDate; }
  inline bool CreationDateHasBeenSet() const { return m_creationDateHasBeenSet; }
  template <typename CreationDateT = Aws::Utils::DateTime>
  void SetCreationDate(CreationDateT&& value) {
    m_creationDateHasBeenSet = true;
    m_creationDate = std::forward<CreationDateT>(value);
  }
  template <typename CreationDateT = Aws::Utils::DateTime>
  IpAccessSettings& WithCreationDate(CreationDateT&& value) {
    SetCreationDate(std::forward<CreationDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The customer managed key used to encrypt sensitive information in the IP
   * access settings.</p>
   */
  inline const Aws::String& GetCustomerManagedKey() const { return m_customerManagedKey; }
  inline bool CustomerManagedKeyHasBeenSet() const { return m_customerManagedKeyHasBeenSet; }
  template <typename CustomerManagedKeyT = Aws::String>
  void SetCustomerManagedKey(CustomerManagedKeyT&& value) {
    m_customerManagedKeyHasBeenSet = true;
    m_customerManagedKey = std::forward<CustomerManagedKeyT>(value);
  }
  template <typename CustomerManagedKeyT = Aws::String>
  IpAccessSettings& WithCustomerManagedKey(CustomerManagedKeyT&& value) {
    SetCustomerManagedKey(std::forward<CustomerManagedKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The additional encryption context of the IP access settings.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetAdditionalEncryptionContext() const { return m_additionalEncryptionContext; }
  inline bool AdditionalEncryptionContextHasBeenSet() const { return m_additionalEncryptionContextHasBeenSet; }
  template <typename AdditionalEncryptionContextT = Aws::Map<Aws::String, Aws::String>>
  void SetAdditionalEncryptionContext(AdditionalEncryptionContextT&& value) {
    m_additionalEncryptionContextHasBeenSet = true;
    m_additionalEncryptionContext = std::forward<AdditionalEncryptionContextT>(value);
  }
  template <typename AdditionalEncryptionContextT = Aws::Map<Aws::String, Aws::String>>
  IpAccessSettings& WithAdditionalEncryptionContext(AdditionalEncryptionContextT&& value) {
    SetAdditionalEncryptionContext(std::forward<AdditionalEncryptionContextT>(value));
    return *this;
  }
  template <typename AdditionalEncryptionContextKeyT = Aws::String, typename AdditionalEncryptionContextValueT = Aws::String>
  IpAccessSettings& AddAdditionalEncryptionContext(AdditionalEncryptionContextKeyT&& key, AdditionalEncryptionContextValueT&& value) {
    m_additionalEncryptionContextHasBeenSet = true;
    m_additionalEncryptionContext.emplace(std::forward<AdditionalEncryptionContextKeyT>(key),
                                          std::forward<AdditionalEncryptionContextValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ipAccessSettingsArn;
  bool m_ipAccessSettingsArnHasBeenSet = false;

  Aws::Vector<Aws::String> m_associatedPortalArns;
  bool m_associatedPortalArnsHasBeenSet = false;

  Aws::Vector<IpRule> m_ipRules;
  bool m_ipRulesHasBeenSet = false;

  Aws::String m_displayName;
  bool m_displayNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_creationDate{};
  bool m_creationDateHasBeenSet = false;

  Aws::String m_customerManagedKey;
  bool m_customerManagedKeyHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_additionalEncryptionContext;
  bool m_additionalEncryptionContextHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
