﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/imagebuilder/model/LifecycleExecutionResourceStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace imagebuilder {
namespace Model {

/**
 * <p>Contains the state of an impacted resource that the runtime instance of the
 * lifecycle policy identified for action.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/LifecycleExecutionResourceState">AWS
 * API Reference</a></p>
 */
class LifecycleExecutionResourceState {
 public:
  AWS_IMAGEBUILDER_API LifecycleExecutionResourceState() = default;
  AWS_IMAGEBUILDER_API LifecycleExecutionResourceState(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API LifecycleExecutionResourceState& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The runtime status of the lifecycle action taken for the impacted
   * resource.</p>
   */
  inline LifecycleExecutionResourceStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(LifecycleExecutionResourceStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline LifecycleExecutionResourceState& WithStatus(LifecycleExecutionResourceStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Messaging that clarifies the reason for the assigned status.</p>
   */
  inline const Aws::String& GetReason() const { return m_reason; }
  inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
  template <typename ReasonT = Aws::String>
  void SetReason(ReasonT&& value) {
    m_reasonHasBeenSet = true;
    m_reason = std::forward<ReasonT>(value);
  }
  template <typename ReasonT = Aws::String>
  LifecycleExecutionResourceState& WithReason(ReasonT&& value) {
    SetReason(std::forward<ReasonT>(value));
    return *this;
  }
  ///@}
 private:
  LifecycleExecutionResourceStatus m_status{LifecycleExecutionResourceStatus::NOT_SET};

  Aws::String m_reason;
  bool m_statusHasBeenSet = false;
  bool m_reasonHasBeenSet = false;
};

}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
