﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/MatchRange.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppMesh {
namespace Model {

/**
 * <p>An object representing the method header to be matched.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/GrpcMetadataMatchMethod">AWS
 * API Reference</a></p>
 */
class GrpcMetadataMatchMethod {
 public:
  AWS_APPMESH_API GrpcMetadataMatchMethod() = default;
  AWS_APPMESH_API GrpcMetadataMatchMethod(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API GrpcMetadataMatchMethod& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The exact method header to be matched on.</p>
   */
  inline const Aws::String& GetExact() const { return m_exact; }
  inline bool ExactHasBeenSet() const { return m_exactHasBeenSet; }
  template <typename ExactT = Aws::String>
  void SetExact(ExactT&& value) {
    m_exactHasBeenSet = true;
    m_exact = std::forward<ExactT>(value);
  }
  template <typename ExactT = Aws::String>
  GrpcMetadataMatchMethod& WithExact(ExactT&& value) {
    SetExact(std::forward<ExactT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The specified beginning characters of the method header to be matched on.</p>
   */
  inline const Aws::String& GetPrefix() const { return m_prefix; }
  inline bool PrefixHasBeenSet() const { return m_prefixHasBeenSet; }
  template <typename PrefixT = Aws::String>
  void SetPrefix(PrefixT&& value) {
    m_prefixHasBeenSet = true;
    m_prefix = std::forward<PrefixT>(value);
  }
  template <typename PrefixT = Aws::String>
  GrpcMetadataMatchMethod& WithPrefix(PrefixT&& value) {
    SetPrefix(std::forward<PrefixT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const MatchRange& GetRange() const { return m_range; }
  inline bool RangeHasBeenSet() const { return m_rangeHasBeenSet; }
  template <typename RangeT = MatchRange>
  void SetRange(RangeT&& value) {
    m_rangeHasBeenSet = true;
    m_range = std::forward<RangeT>(value);
  }
  template <typename RangeT = MatchRange>
  GrpcMetadataMatchMethod& WithRange(RangeT&& value) {
    SetRange(std::forward<RangeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The regex used to match the method header.</p>
   */
  inline const Aws::String& GetRegex() const { return m_regex; }
  inline bool RegexHasBeenSet() const { return m_regexHasBeenSet; }
  template <typename RegexT = Aws::String>
  void SetRegex(RegexT&& value) {
    m_regexHasBeenSet = true;
    m_regex = std::forward<RegexT>(value);
  }
  template <typename RegexT = Aws::String>
  GrpcMetadataMatchMethod& WithRegex(RegexT&& value) {
    SetRegex(std::forward<RegexT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The specified ending characters of the method header to match on.</p>
   */
  inline const Aws::String& GetSuffix() const { return m_suffix; }
  inline bool SuffixHasBeenSet() const { return m_suffixHasBeenSet; }
  template <typename SuffixT = Aws::String>
  void SetSuffix(SuffixT&& value) {
    m_suffixHasBeenSet = true;
    m_suffix = std::forward<SuffixT>(value);
  }
  template <typename SuffixT = Aws::String>
  GrpcMetadataMatchMethod& WithSuffix(SuffixT&& value) {
    SetSuffix(std::forward<SuffixT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_exact;

  Aws::String m_prefix;

  MatchRange m_range;

  Aws::String m_regex;

  Aws::String m_suffix;
  bool m_exactHasBeenSet = false;
  bool m_prefixHasBeenSet = false;
  bool m_rangeHasBeenSet = false;
  bool m_regexHasBeenSet = false;
  bool m_suffixHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
