﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/kinesis-video-archived-media/KinesisVideoArchivedMediaRequest.h>
#include <aws/kinesis-video-archived-media/KinesisVideoArchivedMedia_EXPORTS.h>

#include <utility>

namespace Aws {
namespace KinesisVideoArchivedMedia {
namespace Model {

/**
 */
class GetMediaForFragmentListRequest : public KinesisVideoArchivedMediaRequest {
 public:
  AWS_KINESISVIDEOARCHIVEDMEDIA_API GetMediaForFragmentListRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetMediaForFragmentList"; }

  AWS_KINESISVIDEOARCHIVEDMEDIA_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The name of the stream from which to retrieve fragment media. Specify either
   * this parameter or the <code>StreamARN</code> parameter.</p>
   */
  inline const Aws::String& GetStreamName() const { return m_streamName; }
  inline bool StreamNameHasBeenSet() const { return m_streamNameHasBeenSet; }
  template <typename StreamNameT = Aws::String>
  void SetStreamName(StreamNameT&& value) {
    m_streamNameHasBeenSet = true;
    m_streamName = std::forward<StreamNameT>(value);
  }
  template <typename StreamNameT = Aws::String>
  GetMediaForFragmentListRequest& WithStreamName(StreamNameT&& value) {
    SetStreamName(std::forward<StreamNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the stream from which to retrieve fragment
   * media. Specify either this parameter or the <code>StreamName</code>
   * parameter.</p>
   */
  inline const Aws::String& GetStreamARN() const { return m_streamARN; }
  inline bool StreamARNHasBeenSet() const { return m_streamARNHasBeenSet; }
  template <typename StreamARNT = Aws::String>
  void SetStreamARN(StreamARNT&& value) {
    m_streamARNHasBeenSet = true;
    m_streamARN = std::forward<StreamARNT>(value);
  }
  template <typename StreamARNT = Aws::String>
  GetMediaForFragmentListRequest& WithStreamARN(StreamARNT&& value) {
    SetStreamARN(std::forward<StreamARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of the numbers of fragments for which to retrieve media. You retrieve
   * these values with <a>ListFragments</a>.</p>
   */
  inline const Aws::Vector<Aws::String>& GetFragments() const { return m_fragments; }
  inline bool FragmentsHasBeenSet() const { return m_fragmentsHasBeenSet; }
  template <typename FragmentsT = Aws::Vector<Aws::String>>
  void SetFragments(FragmentsT&& value) {
    m_fragmentsHasBeenSet = true;
    m_fragments = std::forward<FragmentsT>(value);
  }
  template <typename FragmentsT = Aws::Vector<Aws::String>>
  GetMediaForFragmentListRequest& WithFragments(FragmentsT&& value) {
    SetFragments(std::forward<FragmentsT>(value));
    return *this;
  }
  template <typename FragmentsT = Aws::String>
  GetMediaForFragmentListRequest& AddFragments(FragmentsT&& value) {
    m_fragmentsHasBeenSet = true;
    m_fragments.emplace_back(std::forward<FragmentsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_streamName;
  bool m_streamNameHasBeenSet = false;

  Aws::String m_streamARN;
  bool m_streamARNHasBeenSet = false;

  Aws::Vector<Aws::String> m_fragments;
  bool m_fragmentsHasBeenSet = false;
};

}  // namespace Model
}  // namespace KinesisVideoArchivedMedia
}  // namespace Aws
