/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryWriter;

public class DataEntryRewriter
extends DataEntryCopier {
    private final ClassPool classPool;
    private final Charset charset;

    public DataEntryRewriter(ClassPool classPool, Charset charset, DataEntryWriter dataEntryWriter) {
        super(dataEntryWriter);
        this.classPool = classPool;
        this.charset = charset;
    }

    @Override
    protected void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.charset));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset));
        this.copyData(reader, writer);
        ((Writer)writer).flush();
    }

    protected void copyData(Reader reader, Writer writer) throws IOException {
        int i;
        StringBuffer word = new StringBuffer();
        while ((i = reader.read()) >= 0) {
            char c = (char)i;
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '-') {
                word.append(c);
                continue;
            }
            this.writeUpdatedWord(writer, word.toString());
            word.setLength(0);
            writer.write(c);
        }
        this.writeUpdatedWord(writer, word.toString());
    }

    private void writeUpdatedWord(Writer writer, String word) throws IOException {
        if (word.length() > 0) {
            String newClassName;
            String newWord = word;
            boolean containsDots = word.indexOf(46) >= 0;
            String className = containsDots ? word.replace('.', '/') : word;
            Clazz clazz = this.classPool.getClass(className);
            if (clazz != null && !className.equals(newClassName = clazz.getName())) {
                newWord = containsDots ? newClassName.replace('/', '.') : newClassName;
            }
            writer.write(newWord);
        }
    }
}

