#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-ghc
version:              1.8.2
visibility:           public
id:                   clash-ghc-1.8.2-IbwYo0gvNzU5c8CtJCrrb5
key:                  clash-ghc-1.8.2-IbwYo0gvNzU5c8CtJCrrb5
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  e45fbf03c0779d18f49e408aef73a074
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.Leak Clash.GHCi.UI Clash.GHCi.UI.Info
    Clash.GHCi.UI.Monad Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Data.Text.Extra
    Paths_clash_ghc Clash.GHCi.Util Clash.GHCi.UI.Tags

import-dirs:          /usr/lib/ghc-9.6.6/site-local/clash-ghc-1.8.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/clash-ghc-1.8.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/clash-ghc-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/clash-ghc
hs-libraries:         HSclash-ghc-1.8.2-IbwYo0gvNzU5c8CtJCrrb5
depends:
    Cabal-3.10.3.0 array-0.5.6.0 base-4.18.2.1 bytestring-0.11.5.3
    clash-lib-1.8.2-8LFwM6NSorm8Ov3iEZV0Qu
    clash-prelude-1.8.2-4H0WtfdRVV9DtPpnRIWKew containers-0.6.7
    data-binary-ieee754-0.4.4-4UW07Uhzyok6gyNDRTrrKK deepseq-1.4.8.1
    directory-1.3.8.5 exceptions-0.10.7
    extra-1.7.16-8xfhX7g6qo3J4L1mTio5RX filepath-1.4.300.1 ghc-9.6.6
    ghc-bignum-1.3 ghc-boot-9.6.6 ghc-prim-0.10.0
    ghc-typelits-extra-0.4.8-3IFx8qLeIYELkeKoFZISsn
    ghc-typelits-knownnat-0.7.12-8FGZ00l6m4r3rNQt8X72Go
    ghc-typelits-natnormalise-0.7.11-bH2Sq8llSp3HiX1FctzyG ghci-9.6.6
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh haskeline-0.8.2.1
    lens-5.3.3-ATynRreA1Nv2YBaKYxJYCc mtl-2.3.1
    primitive-0.9.1.0-AmjYrOULh0Y82MuHW1HjrT process-1.6.19.0
    reflection-2.1.9-8b7qZBNBXnaA25k5CmR7Hb
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    string-interpolate-0.3.4.0-9WKqrxH0rdQAsw4nMh64wp
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 uniplate-1.6.13-uaUthY0oxlBObgATUMzVg
    unix-2.8.4.0 unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

