#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 cryptol
version:              3.3.0
visibility:           public
id:                   cryptol-3.3.0-7syuPaeA77GCdxrActaXKk
key:                  cryptol-3.3.0-7syuPaeA77GCdxrActaXKk
license:              BSD-3-Clause
copyright:            2013-2025 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             https://tools.galois.com/cryptol
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  0f3d44ba8ca5927edef3412b6ff9f66c
exposed:              True
exposed-modules:
    Cryptol.AES Cryptol.Backend Cryptol.Backend.Arch
    Cryptol.Backend.Concrete Cryptol.Backend.FFI
    Cryptol.Backend.FFI.Error Cryptol.Backend.FloatHelpers
    Cryptol.Backend.Monad Cryptol.Backend.SBV Cryptol.Backend.SeqMap
    Cryptol.Backend.What4 Cryptol.Backend.WordValue Cryptol.Eval
    Cryptol.Eval.Concrete Cryptol.Eval.Env Cryptol.Eval.FFI
    Cryptol.Eval.FFI.GenHeader Cryptol.Eval.Generic Cryptol.Eval.Prims
    Cryptol.Eval.Reference Cryptol.Eval.SBV Cryptol.Eval.Type
    Cryptol.Eval.Value Cryptol.Eval.What4 Cryptol.F2
    Cryptol.IR.FreeVars Cryptol.IR.TraverseNames Cryptol.ModuleSystem
    Cryptol.ModuleSystem.Base Cryptol.ModuleSystem.Binds
    Cryptol.ModuleSystem.Env Cryptol.ModuleSystem.Exports
    Cryptol.ModuleSystem.Fingerprint Cryptol.ModuleSystem.Interface
    Cryptol.ModuleSystem.Monad Cryptol.ModuleSystem.Name
    Cryptol.ModuleSystem.Names Cryptol.ModuleSystem.NamingEnv
    Cryptol.ModuleSystem.NamingEnv.Types Cryptol.ModuleSystem.Renamer
    Cryptol.ModuleSystem.Renamer.Error
    Cryptol.ModuleSystem.Renamer.ImplicitImports
    Cryptol.ModuleSystem.Renamer.Imports
    Cryptol.ModuleSystem.Renamer.Monad Cryptol.Parser
    Cryptol.Parser.AST Cryptol.Parser.ExpandPropGuards
    Cryptol.Parser.Layout Cryptol.Parser.Lexer Cryptol.Parser.Name
    Cryptol.Parser.Names Cryptol.Parser.NoInclude Cryptol.Parser.NoPat
    Cryptol.Parser.Position Cryptol.Parser.Selector
    Cryptol.Parser.Token Cryptol.Parser.Unlit Cryptol.Parser.Utils
    Cryptol.PrimeEC Cryptol.Project Cryptol.Project.Cache
    Cryptol.Project.Config Cryptol.Project.Monad
    Cryptol.Project.WildMatch Cryptol.REPL.Browse Cryptol.REPL.Command
    Cryptol.REPL.Help Cryptol.REPL.Monad Cryptol.REPL.Trie Cryptol.SHA
    Cryptol.Symbolic Cryptol.Symbolic.SBV Cryptol.Symbolic.What4
    Cryptol.Testing.Random Cryptol.Transform.MonoValues
    Cryptol.Transform.Specialize Cryptol.TypeCheck
    Cryptol.TypeCheck.AST Cryptol.TypeCheck.Default
    Cryptol.TypeCheck.Error Cryptol.TypeCheck.FFI
    Cryptol.TypeCheck.FFI.Error Cryptol.TypeCheck.FFI.FFIType
    Cryptol.TypeCheck.Infer Cryptol.TypeCheck.InferTypes
    Cryptol.TypeCheck.Instantiate Cryptol.TypeCheck.Interface
    Cryptol.TypeCheck.Kind Cryptol.TypeCheck.Module
    Cryptol.TypeCheck.ModuleBacktickInstance
    Cryptol.TypeCheck.ModuleInstance Cryptol.TypeCheck.Monad
    Cryptol.TypeCheck.PP Cryptol.TypeCheck.Parseable
    Cryptol.TypeCheck.Sanity Cryptol.TypeCheck.SimpType
    Cryptol.TypeCheck.SimpleSolver Cryptol.TypeCheck.Solve
    Cryptol.TypeCheck.Solver.Class Cryptol.TypeCheck.Solver.Improve
    Cryptol.TypeCheck.Solver.InfNat Cryptol.TypeCheck.Solver.Numeric
    Cryptol.TypeCheck.Solver.Numeric.Fin
    Cryptol.TypeCheck.Solver.Numeric.Interval
    Cryptol.TypeCheck.Solver.SMT Cryptol.TypeCheck.Solver.Selector
    Cryptol.TypeCheck.Solver.Types Cryptol.TypeCheck.Solver.Utils
    Cryptol.TypeCheck.Subst Cryptol.TypeCheck.TCon
    Cryptol.TypeCheck.Type Cryptol.TypeCheck.TypeMap
    Cryptol.TypeCheck.TypeOf Cryptol.TypeCheck.TypePat
    Cryptol.TypeCheck.Unify Cryptol.Utils.Benchmark Cryptol.Utils.Debug
    Cryptol.Utils.Fixity Cryptol.Utils.Ident Cryptol.Utils.Logger
    Cryptol.Utils.Misc Cryptol.Utils.PP Cryptol.Utils.Panic
    Cryptol.Utils.Patterns Cryptol.Utils.RecordMap Cryptol.Utils.Types
    Cryptol.Version

hidden-modules:
    Cryptol.Parser.LexerUtils Cryptol.Parser.ParserUtils
    Cryptol.Prelude GHC.Num.Compat Paths_cryptol GitRev

import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.3.0-7syuPaeA77GCdxrActaXKk
depends:
    GraphSCC-1.0.4-BvH3gdGqztj6roihacPJAg
    MemoTrie-0.6.11-LhrSQxfjcFyGJnnAbOCHFa
    arithmoi-0.13.2.0-FwOOu99XK7t3EjMjczDTQr array-0.5.4.0
    async-2.2.5-EP91qAI3cOI8P3d6QWskI6 base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz
    bv-sized-1.0.6-8QW4ow5jV3KCdNtQvE6zuW bytestring-0.11.5.3
    containers-0.6.7
    criterion-measurement-0.2.3.0-KY6kelIUE2nElaJ9kbobqn
    cryptohash-sha256-0.11.102.1-3MKPx1l0dHy73OOEfrcDBi deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    ghc-bignum-1.3 ghc-prim-0.9.1 gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    hgmp-0.1.2.1-K6detfq0z8nHi1lyIca6iB
    language-c99-0.2.0-I2YO1ITQKgi7h1b2QKXgRh
    language-c99-simple-0.3.0-LtsnH0LVnu56Mhd4fxlDo
    libBF-0.6.6-JPpIsYW8fsEAC3j9kxnGnI
    libffi-0.2.1-DPsLfzr2gvt1V2FBULxP58
    monad-control-1.0.3.1-1uLiNwqbFdV8VlLjQHhhBl
    monadLib-3.10.3-9u69WCWPr5d93B1By2kxXa mtl-2.2.2
    panic-0.4.0.1-3QvhbYIlGoL4pBeY3qhGHr
    parameterized-utils-2.1.10.0-F20ECWavsKv507ya7oMjIB pretty-1.1.3.6
    pretty-show-1.10-Dwgsrh12Px3tJNgclFhNg
    prettyprinter-1.7.1-2fDIWQCpfcFF0VMlKg6ON0 process-1.6.18.0
    sbv-10.2-2bLqASNuOQd9NdlPelj3qx
    simple-smt-0.9.8-GxJMYuz27wdJmfDJ6DG7cL stm-2.5.1.0
    strict-0.5-8rgIjbeAooS5grh3KRoRGd text-2.0.2
    tf-random-0.5-FgY0wZ3ThXlA0Bd80Vf7vx time-1.12.2
    toml-parser-2.0.1.2-BCwWpI8Hs772Hzt8rgbEeb
    transformers-base-0.4.6-8A6J7puCxi27yha2ploIhm unix-2.7.3
    vector-0.13.2.0-9W9rHKyBrY08EKASla5WO0
    what4-1.6-LsfDMIeZ960BdZxryX0rvO

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-cryptol-z-cryptol-repl-internal
version:              3.3.0
package-name:         cryptol
lib-name:             cryptol-repl-internal
id:                   cryptol-3.3.0-3c83nzEnJkG2GMib9rXpM-cryptol-repl-internal
key:                  cryptol-3.3.0-3c83nzEnJkG2GMib9rXpM-cryptol-repl-internal
license:              BSD-3-Clause
copyright:            2013-2025 Galois Inc.
maintainer:           cryptol@galois.com
author:               Galois, Inc.
homepage:             https://tools.galois.com/cryptol
synopsis:             Cryptol: The Language of Cryptography
description:
    Cryptol is a domain-specific language for specifying cryptographic algorithms. A Cryptol implementation of an algorithm resembles its mathematical specification more closely than an implementation in a general purpose language. For more, see <http://www.cryptol.net/>.

category:             Language
abi:                  82dc040e274aa13ee1cefaa6cf433c2a
exposed-modules:      REPL.Haskeline REPL.Logo
hidden-modules:       Paths_cryptol
import-dirs:          /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/cryptol-3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/cryptol
hs-libraries:         HScryptol-3.3.0-3c83nzEnJkG2GMib9rXpM-cryptol-repl-internal
depends:
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1 base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz containers-0.6.7
    cryptol-3.3.0-7syuPaeA77GCdxrActaXKk directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2 haskeline-0.8.2
    monad-control-1.0.3.1-1uLiNwqbFdV8VlLjQHhhBl text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/cryptol/html/cryptol.haddock
haddock-html:         /usr/share/doc/cryptol/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

