/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPasteSettings;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ResultSetHandlerPasteSpecial
extends ResultSetHandlerMain {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerPasteSpecial.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        IResultSetPresentation presentation = resultSet.getActivePresentation();
        if (!(presentation instanceof IResultSetEditor)) {
            return null;
        }
        AdvancedPasteConfigDialog configDialog = new AdvancedPasteConfigDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (configDialog.open() == 0) {
            ((IResultSetEditor)((Object)presentation)).pasteFromClipboard(configDialog.pasteSettings);
        }
        return null;
    }

    private static class AdvancedPasteConfigDialog
    extends BaseDialog {
        private static final String DIALOG_ID = "AdvancedPasteOptions";
        private static final String PROP_INSERT_MULTIPLE_ROWS = "insertMultipleRows";
        private static final String PROP_IGNORE_QUOTES = "ignoreQuotes";
        private static final String PROP_INSERT_NULLS = "insertNulls";
        private static final String PROP_NULL_VALUE_MARK = "nullValueMark";
        private final IDialogSettings dialogSettings;
        private final ResultSetPasteSettings pasteSettings;
        private Button insertMultipleRowsCheck;
        private Button ignoreQuotesCheck;
        private Button insertNullsCheck;
        private Combo nullValueMarkCombo;

        public AdvancedPasteConfigDialog(@NotNull Shell shell) {
            super(shell, ResultSetMessages.dialog_paste_as_title, null);
            this.setShellStyle(67680);
            this.dialogSettings = UIUtils.getDialogSettings((String)DIALOG_ID);
            this.pasteSettings = new ResultSetPasteSettings();
            if (this.dialogSettings.get(PROP_INSERT_MULTIPLE_ROWS) != null) {
                this.pasteSettings.setInsertMultipleRows(this.dialogSettings.getBoolean(PROP_INSERT_MULTIPLE_ROWS));
            }
            if (this.dialogSettings.get(PROP_IGNORE_QUOTES) != null) {
                this.pasteSettings.setIgnoreQuotes(this.dialogSettings.getBoolean(PROP_IGNORE_QUOTES));
            }
            if (this.dialogSettings.get(PROP_INSERT_NULLS) != null) {
                this.pasteSettings.setInsertNulls(this.dialogSettings.getBoolean(PROP_INSERT_NULLS));
            }
            if (this.dialogSettings.get(PROP_NULL_VALUE_MARK) != null) {
                this.pasteSettings.setNullValueMark(this.dialogSettings.get(PROP_NULL_VALUE_MARK));
            }
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            this.insertMultipleRowsCheck = UIUtils.createCheckbox((Composite)composite, (String)ResultSetMessages.dialog_paste_as_insert_multiple_rows_text, (String)ResultSetMessages.dialog_paste_as_insert_multiple_rows_tip, (boolean)this.pasteSettings.isInsertMultipleRows(), (int)1);
            this.ignoreQuotesCheck = UIUtils.createCheckbox((Composite)composite, (String)ResultSetMessages.dialog_paste_as_ignore_quotes_text, (String)ResultSetMessages.dialog_paste_as_ignore_quotes_tip, (boolean)this.pasteSettings.isIgnoreQuotes(), (int)1);
            this.insertNullsCheck = UIUtils.createCheckbox((Composite)composite, (String)ResultSetMessages.dialog_paste_as_insert_nulls_text, (String)ResultSetMessages.dialog_paste_as_insert_nulls_tip, (boolean)this.pasteSettings.isInsertNulls(), (int)1);
            this.insertNullsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    nullValueMarkCombo.setEnabled(insertNullsCheck.getSelection());
                }
            });
            this.nullValueMarkCombo = UIUtils.createLabelCombo((Composite)UIUtils.createPlaceholder((Composite)composite, (int)2), (String)ResultSetMessages.dialog_paste_as_null_value_mark_text, (String)ResultSetMessages.dialog_paste_as_null_value_mark_tip, (int)0);
            this.nullValueMarkCombo.add("NULL");
            this.nullValueMarkCombo.add("");
            this.nullValueMarkCombo.setText(this.pasteSettings.getNullValueMark());
            this.nullValueMarkCombo.setEnabled(this.pasteSettings.isInsertNulls());
            return composite;
        }

        protected void okPressed() {
            this.pasteSettings.setInsertMultipleRows(this.insertMultipleRowsCheck.getSelection());
            this.pasteSettings.setIgnoreQuotes(this.ignoreQuotesCheck.getSelection());
            this.pasteSettings.setInsertNulls(this.insertNullsCheck.getSelection());
            this.pasteSettings.setNullValueMark(this.nullValueMarkCombo.getText());
            this.dialogSettings.put(PROP_INSERT_MULTIPLE_ROWS, this.pasteSettings.isInsertMultipleRows());
            this.dialogSettings.put(PROP_IGNORE_QUOTES, this.pasteSettings.isIgnoreQuotes());
            this.dialogSettings.put(PROP_INSERT_NULLS, this.pasteSettings.isInsertNulls());
            this.dialogSettings.put(PROP_NULL_VALUE_MARK, this.pasteSettings.getNullValueMark());
            super.okPressed();
        }
    }
}

