/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphUtilities;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.RevertableChange;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.graph.VirtualNode;

class VirtualNodeCreation
extends RevertableChange {
    private final Edge edge;
    private final DirectedGraph graph;
    private final Node[] nodes;
    private final Edge[] edges;
    private static final int INNER_EDGE_X = 2;
    private static final int LONG_EDGE_X = 8;

    public VirtualNodeCreation(Edge edge, DirectedGraph graph) {
        Edge currentEdge;
        this.edge = edge;
        this.graph = graph;
        int size = edge.target.rank - edge.source.rank - 1;
        int offset = edge.source.rank + 1;
        Node prevNode = edge.source;
        this.nodes = new Node[size];
        this.edges = new Edge[size + 1];
        Insets padding = new Insets(0, edge.getPadding(), 0, edge.getPadding());
        Subgraph s = GraphUtilities.getCommonAncestor(edge.source, edge.target);
        int i = 0;
        while (i < size) {
            VirtualNode currentNode = new VirtualNode("Virtual" + i + ":" + String.valueOf(edge), s);
            this.nodes[i] = currentNode;
            currentNode.width = edge.getWidth();
            if (s != null) {
                currentNode.nestingIndex = s.nestingIndex;
            }
            currentNode.height = 0;
            currentNode.setPadding(padding);
            currentNode.rank = offset + i;
            graph.ranks.getRank(offset + i).add(currentNode);
            currentEdge = new Edge(prevNode, currentNode, 1, edge.weight * 8);
            if (i == 0) {
                currentEdge.weight = edge.weight * 2;
                currentEdge.setSourceOffset(edge.offsetSource);
            }
            this.edges[i] = currentEdge;
            graph.edges.add(this.edges[i]);
            graph.nodes.add(currentNode);
            prevNode = currentNode;
            ++i;
        }
        currentEdge = new Edge(prevNode, edge.target, 1, edge.weight * 2);
        currentEdge.setTargetOffset(edge.offsetTarget);
        this.edges[this.edges.length - 1] = currentEdge;
        graph.edges.add(currentEdge);
        graph.removeEdge(edge);
    }

    @Override
    void revert() {
        this.edge.start = this.edges[0].start;
        this.edge.end = this.edges[this.edges.length - 1].end;
        this.edge.vNodes = new NodeList();
        Object[] objectArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            Edge edge2 = objectArray[n2];
            this.graph.removeEdge(edge2);
            ++n2;
        }
        objectArray = this.nodes;
        n = this.nodes.length;
        n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.edge.vNodes.add(node);
            this.graph.removeNode((Node)node);
            ++n2;
        }
        this.edge.source.outgoing.add(this.edge);
        this.edge.target.incoming.add(this.edge);
        this.graph.edges.add(this.edge);
    }
}

