/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.txn;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.querylog.QueryLogViewer;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.utils.CommonUtils;

public abstract class TransactionInfoDialog
extends AbstractPopupPanel {
    private static final QMEventFilter VOID_FILTER = event -> false;
    private final IWorkbenchPart activeEditor;
    protected QueryLogViewer logViewer;
    protected Button showAllCheck;
    protected Button showPreviousCheck;

    TransactionInfoDialog(@NotNull Shell parentShell, @NotNull String title, @NotNull IWorkbenchPart activeEditor) {
        super(parentShell, title);
        this.activeEditor = activeEditor;
    }

    protected abstract DBCExecutionContext getCurrentContext();

    protected void createTransactionLogPanel(@NotNull Composite composite) {
        DBCExecutionContext context = this.getCurrentContext();
        QMEventFilter filter = context == null ? VOID_FILTER : this.createContextFilter(context);
        this.logViewer = new QueryLogViewer(composite, this.activeEditor.getSite(), filter, false, true);
        this.logViewer.setUseDefaultFilter(false);
        Object gd = this.logViewer.getControl().getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).heightHint = this.logViewer.getControl().getHeaderHeight() + this.logViewer.getControl().getItemHeight() * 5;
        }
        this.showAllCheck = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.transaction_info_dialog_checkbox_show_all_queries, (String)CoreMessages.transaction_info_dialog_label_show_all_transaction_queries, (boolean)false, (int)1);
        this.showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionInfoDialog.this.updateTransactionFilter();
            }
        });
        this.showPreviousCheck = UIUtils.createCheckbox((Composite)composite, (String)CoreMessages.transaction_info_dialog_checkbox_show_previous_transactions, (String)CoreMessages.transaction_info_dialog_label_otherwise, (boolean)false, (int)1);
        this.showPreviousCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionInfoDialog.this.updateTransactionFilter();
            }
        });
        this.closeOnFocusLost(new Control[]{this.logViewer.getSearchText(), this.logViewer.getControl(), this.showAllCheck, this.showPreviousCheck});
    }

    protected void updateTransactionFilter() {
        DBCExecutionContext context = this.getCurrentContext();
        QMEventFilter filter = context == null ? VOID_FILTER : this.createContextFilter(context);
        this.logViewer.setFilter(filter);
        this.logViewer.refresh();
    }

    protected QMEventFilter createContextFilter(DBCExecutionContext executionContext) {
        if (executionContext == null) {
            return VOID_FILTER;
        }
        boolean showAll = this.showAllCheck != null && this.showAllCheck.getSelection();
        boolean showPrevious = this.showPreviousCheck != null && this.showPreviousCheck.getSelection();
        QMMConnectionInfo currentSession = QMUtils.getCurrentConnection((DBCExecutionContext)executionContext);
        QMMTransactionSavepointInfo currentSP = QMUtils.getCurrentTransaction((DBCExecutionContext)executionContext);
        return event -> {
            QMMObject object = event.getObject();
            if (object instanceof QMMStatementExecuteInfo) {
                QMMStatementExecuteInfo exec = (QMMStatementExecuteInfo)object;
                if (!showPrevious && !CommonUtils.equalObjects((Object)exec.getSavepoint(), (Object)currentSP)) {
                    return false;
                }
                if (!showAll && !CommonUtils.equalObjects((Object)exec.getStatement().getConnection(), (Object)currentSession)) {
                    return false;
                }
                DBCExecutionPurpose purpose = exec.getStatement().getPurpose();
                if (purpose == DBCExecutionPurpose.META || purpose == DBCExecutionPurpose.UTIL) {
                    return false;
                }
                return showAll || exec.isTransactional();
            }
            return false;
        };
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

