/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cts.registry.Registry;
import org.cts.registry.RegistryManagerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryManager {
    static final Logger LOGGER = LoggerFactory.getLogger(RegistryManager.class);
    private final Map<String, Registry> registries = new HashMap<String, Registry>();
    private final List<RegistryManagerListener> listeners = new ArrayList<RegistryManagerListener>();

    public void addRegistryManagerListener(RegistryManagerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeRegistryManagerListener(RegistryManagerListener listener) {
        return this.listeners.remove(listener);
    }

    public void addRegistry(Registry registryClass) {
        this.addRegistry(registryClass, false);
    }

    public void addRegistry(Registry registry, boolean replace) {
        LOGGER.trace("Adding a new registry " + registry.getRegistryName());
        String registryName = registry.getRegistryName().toUpperCase();
        if (!replace && this.registries.containsKey(registryName)) {
            throw new IllegalArgumentException("Registry " + registryName + " already exists");
        }
        this.registries.put(registryName, registry);
        this.fireRegistryAdded(registry.getRegistryName());
    }

    private void fireRegistryAdded(String registryName) {
        for (RegistryManagerListener listener : this.listeners) {
            listener.registryAdded(registryName);
        }
    }

    public boolean contains(String name) {
        return this.registries.containsKey(name.toUpperCase());
    }

    public String[] getRegistryNames() {
        LOGGER.trace("Getting all registry names");
        ArrayList<String> names = new ArrayList<String>();
        for (Registry r : this.registries.values()) {
            names.add(r.getRegistryName());
        }
        return names.toArray(new String[0]);
    }

    public Registry getRegistry(String registryName) {
        LOGGER.trace("Getting the registry " + registryName);
        return this.registries.get(registryName.toUpperCase());
    }
}

