#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-KV7UFpU9RFAI5KtvsaxwTf
key:                  dhall-1.42.2-KV7UFpU9RFAI5KtvsaxwTf
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  576d837339cd6a5b61ad7aaebc852ee2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-KV7UFpU9RFAI5KtvsaxwTf
depends:
    Diff-0.5-CBdaR8gCBwy5frY7c2tTEC
    aeson-2.1.2.1-6ANjbGmrSDg8K6hz3VmYXP
    aeson-pretty-0.8.10-6UR3e8LgzRvIwEvRPnGaD4
    ansi-terminal-1.0.2-APpGXfviLhwGAqnzweVkae
    atomic-write-0.2.1.1-1EDPf8yfil7uilk4N3oSD base-4.17.2.1
    base16-bytestring-1.0.2.0-HAJb6KkTWjgCS5rMtXMipF
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-IP68CV0DvpE446u5n94xId
    cborg-0.2.10.0-2ebMLTG0wAP1HPi8KJ8I65
    cborg-json-0.2.6.0-EpLEXDT4GxT7Alj4Xsg19K containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-HCf3gUf2Bb99ZxhoAI2yXA
    data-fix-0.3.4-CWRtuXZMo7zJdPmIpKlN3h deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-DtuZQ6ypbpq63uyhr46ZP8 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-FoCeSeerRfnJ85gA5e3zIY
    hashable-1.4.4.0-L4Cy5OzOiFo7EDda82f1f2 haskeline-0.8.2
    http-client-0.7.19-INRexYbbc84G8M9afYhYa4
    http-client-tls-0.3.6.4-4b1LqwZqELbD3PiYpWlMw1
    http-types-0.12.4-BDAI9vbdFnhAzARYRhzpQY
    indexed-traversable-0.1.4-CBOJsYbUtASLSsy40aEvj2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-11G1C9ltcKPC7KewoELwDN
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-DCTjueINivX2RvibFUmCb5
    optparse-applicative-0.18.1.0-CKCQVkeW052FlPJiFlkCaf
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-FLyncnKcoxT1LNnzWO0yCU
    pretty-simple-4.1.3.0-erYauGNUuI4VkqVZSMeGD
    prettyprinter-1.7.1-H1CnA9YdkYYkwP4aBwQ7e
    prettyprinter-ansi-terminal-1.1.3-5l4bMV180UmCJ9CGBOQJt
    profunctors-5.6.3-H3aGaptwIhVL5gQLua9Hf2
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-eAJHzbOczMAHNfebkRy2Z
    serialise-0.2.6.1-FKBYSYw0VmJF3gaKTN3nMV template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-L9YYwJOoAItE1bLaNM3CQp
    text-short-0.1.6-DRkQIC1nZoSsghKVSv5ps
    th-lift-instances-0.1.20-8zCS0DxdFO9CfbfHZy6MTv time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-HfukfXMXV6LHwjUE321L3t
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    vector-0.13.2.0-ESntcdl2teUG0zU6GNugJH

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

