#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-BmH2C3PGaRcBHdDXNquiAj
key:                  dhall-1.42.3-BmH2C3PGaRcBHdDXNquiAj
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  a166ef09edb0f83699b54fddb00af6a2
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-BmH2C3PGaRcBHdDXNquiAj
depends:
    Diff-0.5-CuN0gcwErnxTovm8uRK5M aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto
    aeson-pretty-0.8.10-4zjwdGc7xq045iIhkhi3FG
    ansi-terminal-1.0.2-4YFJ3O2CGvXHeK0JwiwGsH
    atomic-write-0.2.1.1-K0uWQ5tnShvGaj0V6b59Wl base-4.17.2.1
    base16-bytestring-1.0.2.0-8cYMJjJ2evUJdToLJsrqX6
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-2YJdsrn6pUkJFkSDuYKbj5
    cborg-0.2.10.0-2grYD3bACcf1Lj0SfcaMWo
    cborg-json-0.2.6.0-CvSWb1c5xIhGu2DLnqt6B containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-6C5UECA6MAF6E91Quak0P0
    data-fix-0.3.4-26nh3WduKwBEXOlqzHUIaB deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-CST4FwrsSwpKgQT70DzwaP exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-3IrcEwKFjlILWBpWK7mTx
    hashable-1.4.5.0-EdCBZmCkEma7WCMhhvMdNf haskeline-0.8.2
    http-client-0.7.19-LmgoxlGljmmJ4yfMmVG9tj
    http-client-tls-0.3.6.4-CWf1zUvMsiN34DRbq0lWlt
    http-types-0.12.4-36n5pJIqV0vLBUyZ9LbmPR
    indexed-traversable-0.1.4-6I34tNI5leL7QXgWHpiE2g
    megaparsec-9.7.0-6vU2vxyqrAyGY5juwv0O1p
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-54CTgPtYe4zITDsYIFYufz
    optparse-applicative-0.18.1.0-Jq3vguaa3HPDo4Go2ncIVD
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-4rpysLeXm1s48gFZZHmXX6
    pretty-simple-4.1.3.0-GwDyKbdo8FNGywl2WF8CXS
    prettyprinter-1.7.1-7cHMA52o3usJvB7pVINYaP
    prettyprinter-ansi-terminal-1.1.3-KBc7B4rdJaz2aaKpFfwo1G
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-6LouxILG2OZJHi2GF4rlkX
    serialise-0.2.6.1-K0hskYl7CQZ2mYKJu2dJUy template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-DZwXqh2BGs01qk4Ed56tpG
    text-short-0.1.6-FSqhXd1iifKLcJuueoyEev
    th-lift-instances-0.1.20-68BUc06HvFb9DBortUTYeM time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-LBxlfXjsbERDOpdX4AlQOF
    unordered-containers-0.2.20-KWLixwBKCEK6ORqUSVo2CW
    vector-0.13.2.0-BnQJYTBpbJKJ2sldbPuyJj

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

