#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-y5XJ20zltb6rfVIEHBqUS
key:                  dhall-1.42.3-y5XJ20zltb6rfVIEHBqUS
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  f6030dd548261cce16b0c7d6d7afac18
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-y5XJ20zltb6rfVIEHBqUS
depends:
    Diff-0.5-3fWbMSZyrbJIXl91nyKDLU
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j
    aeson-pretty-0.8.10-9DH6Hkbn0Vw9xdd4TlCy61
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1
    atomic-write-0.2.1.1-HhkalpB7tJD6xCvdy6g6TI base-4.17.2.1
    base16-bytestring-1.0.2.0-H62yvQKnYXI2vVR0tnIhus
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Fpgl4YyjrVl4Gttb0PploH
    cborg-0.2.10.0-FjY4sHQNuYcZPxUVB5iot
    cborg-json-0.2.6.0-DQLQrvx95XZ2KLnnCPYyMW containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-2g498iSf0B3Cqz5irgXOKL
    data-fix-0.3.4-DGL7Qd0PBAVJJ1YcgvjmGz deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-9trvXhSocPAD0MDHslM6Mi exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-L2R2b9vpX8P3uDdk8ryBWu
    hashable-1.4.6.0-JiQr1Tltq7G4W5bcwnoSMj haskeline-0.8.2
    http-client-0.7.19-EHZ8YuN7FJhcdM1bWuZGu
    http-client-tls-0.3.6.4-7GHufzv4aig4Ncu6224c0U
    http-types-0.12.4-8HR0lcMpUwL4edtlDqx8uG
    indexed-traversable-0.1.4-4QkGZjX8pz4IX54GPYwjuC
    megaparsec-9.7.0-8uORpW7l6sW5AZf9TKEbic
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-IKG3zvKYtEQ3q1XygxFZnU
    optparse-applicative-0.18.1.0-7S1OQWk23vFFb1lO3AOVmW
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-ASMNvzJYM16NPhDEtW0Qz
    pretty-simple-4.1.3.0-EuD3hdjA6Vp3Cr45dnCuvi
    prettyprinter-1.7.1-CSlGZoOoBlWC7jpjoL7RBV
    prettyprinter-ansi-terminal-1.1.3-Jr4QPQoU3qM4H72wvTz5B6
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-DVR29LrvvAIAHP7TdQIZgA
    serialise-0.2.6.1-Ei5vG5mZ7hfIS89egVNZ6U template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1yHpaCOYmlr3KwcE7tsrj6
    text-short-0.1.6-5jcHLleQPKDZjvOjdiYAI
    th-lift-instances-0.1.20-JYYB3USqshX5wOnApGngym time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-9t2FupNpdHvF9CotjWq7e6
    unordered-containers-0.2.20-C5ENqrDu1w64CLikkGEoYH
    vector-0.13.2.0-o0y58FfPZzKSAM3ADJGlg

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

